/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectPreferenceSessionTest
extends WorkspaceSessionTest {
    private static final String DIR_NAME = ".settings";
    private static final String FILE_EXTENSION = "prefs";

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", ProjectPreferenceSessionTest.class);
    }

    public ProjectPreferenceSessionTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        ProjectPreferenceSessionTest.getWorkspace().save(true, this.getMonitor());
    }

    public void testDeleteFileBeforeLoad1() {
        IProject project = ProjectPreferenceSessionTest.getProject("testDeleteFileBeforeLoad");
        String qualifier = "test.delete.file.before.load";
        this.ensureExistsInWorkspace((IResource)project, true);
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        node.put("key", "value");
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferenceSessionTest.fail((String)"1.99", (Throwable)e);
        }
        this.waitForRefresh();
        IFile file = project.getFile(new Path(DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION));
        ProjectPreferenceSessionTest.assertTrue((String)"2.0", (boolean)file.exists());
        ProjectPreferenceSessionTest.assertTrue((String)"2.1", (boolean)file.getLocation().toFile().exists());
    }

    public void testDeleteFileBeforeLoad2() {
        IProject project = ProjectPreferenceSessionTest.getProject("testDeleteFileBeforeLoad");
        Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (!"org.eclipse.core.runtime".equals(plugin)) {
                    return;
                }
                Throwable t = status.getException();
                if (t == null) {
                    return;
                }
                if (t instanceof BackingStoreException) {
                    ProjectPreferenceSessionTest.fail((String)"1.0", (Throwable)t);
                }
            }
        };
        try {
            try {
                Platform.addLogListener((ILogListener)listener);
                project.delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                ProjectPreferenceSessionTest.fail((String)"1.99", (Throwable)e);
                Platform.removeLogListener((ILogListener)listener);
            }
        }
        finally {
            Platform.removeLogListener((ILogListener)listener);
        }
    }

    public void testSaveLoad1() {
        IProject project = ProjectPreferenceSessionTest.getProject("testSaveLoad");
        this.ensureExistsInWorkspace((IResource)project, true);
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("test.save.load");
        node.put("key", "value");
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferenceSessionTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testSaveLoad2() {
        IProject project = ProjectPreferenceSessionTest.getProject("testSaveLoad");
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("test.save.load");
        ProjectPreferenceSessionTest.assertEquals((String)"1.0", (String)"value", (String)node.get("key", null));
    }

    private static IProject getProject(String name) {
        return ProjectPreferenceSessionTest.getWorkspace().getRoot().getProject(name);
    }
}

