/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestClosedProjectLocation
extends WorkspaceSerializationTest {
    IPath location = Platform.getLocation().removeLastSegments(1).append("OtherLocation");

    public TestClosedProjectLocation() {
    }

    public TestClosedProjectLocation(String name) {
        super(name);
    }

    public void test1() {
        IProject project = this.workspace.getRoot().getProject("CrashProject");
        IFile file = project.getFile("CrashFile");
        try {
            IProjectDescription desc = this.workspace.newProjectDescription("CrashProject");
            desc.setLocation(this.location);
            project.create(desc, this.getMonitor());
            project.open(this.getMonitor());
            this.ensureExistsInWorkspace((IResource)file, true);
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            TestClosedProjectLocation.fail((String)"1.0", (Throwable)e);
        }
        TestClosedProjectLocation.assertEquals((String)"1.1", (Object)this.location, (Object)project.getLocation());
        try {
            this.workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestClosedProjectLocation.fail((String)"1.2", (Throwable)e);
        }
    }

    public void test2() {
        try {
            IProject project = this.workspace.getRoot().getProject("CrashProject");
            IFile file = project.getFile("CrashFile");
            TestClosedProjectLocation.assertTrue((String)"1.0", (boolean)project.exists());
            TestClosedProjectLocation.assertTrue((String)"1.1", (!project.isOpen() ? 1 : 0) != 0);
            TestClosedProjectLocation.assertTrue((String)"1.2", (!file.exists() ? 1 : 0) != 0);
            TestClosedProjectLocation.assertEquals((String)"1.3", (Object)this.location, (Object)project.getLocation());
        }
        finally {
            this.ensureDoesNotExistInFileSystem(this.location.toFile());
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestClosedProjectLocation.class);
    }
}

