/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestInterestingProjectPersistence
extends WorkspaceSessionTest {
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IProject project4;
    private IFile file1;
    private IFile file2;
    private IFile file3;
    private IFile file4;

    public TestInterestingProjectPersistence() {
    }

    public TestInterestingProjectPersistence(String name) {
        super(name);
    }

    protected void setAutoBuilding(boolean value) throws CoreException {
        IWorkspace workspace = TestInterestingProjectPersistence.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        workspace.setDescription(desc);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = TestInterestingProjectPersistence.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.project2 = root.getProject("Project2");
        this.project3 = root.getProject("Project3");
        this.project4 = root.getProject("Project4");
        this.file1 = this.project1.getFile("File1");
        this.file2 = this.project2.getFile("File2");
        this.file3 = this.project3.getFile("File3");
        this.file4 = this.project4.getFile("File4");
    }

    public void test1() {
        IResource[] resources = new IResource[]{this.project1, this.project2, this.project3, this.project4, this.file1, this.file2, this.file3, this.file4};
        this.ensureExistsInWorkspace(resources, true);
        try {
            IWorkspace workspace = TestInterestingProjectPersistence.getWorkspace();
            IWorkspaceDescription desc = workspace.getDescription();
            desc.setAutoBuilding(false);
            workspace.setDescription(desc);
            IProjectDescription description = this.project1.getDescription();
            ICommand command = description.newCommand();
            Map args = command.getArguments();
            args.put("BuildID", "Project1Build1");
            command.setBuilderName("org.eclipse.core.tests.resources.deltaverifierbuilder");
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            this.project1.setDescription(description, this.getMonitor());
            this.project1.build(6, this.getMonitor());
            TestInterestingProjectPersistence.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestInterestingProjectPersistence.fail((String)"2.0", (Throwable)e);
        }
    }

    public void test2() {
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        builder.checkDeltas(new IProject[]{this.project1, this.project2, this.project3, this.project4});
        builder.requestDeltas(new IProject[]{this.project1, this.project2, this.project4});
        try {
            this.file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.project1.build(10, this.getMonitor());
            ArrayList<IProject> received = builder.getReceivedDeltas();
            TestInterestingProjectPersistence.assertEquals((String)"1.0", (int)1, (int)received.size());
            TestInterestingProjectPersistence.assertTrue((String)"1.1", (boolean)received.contains(this.project1));
            ArrayList<IProject> empty = builder.getEmptyDeltas();
            TestInterestingProjectPersistence.assertEquals((String)"1.2", (int)0, (int)empty.size());
            TestInterestingProjectPersistence.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestInterestingProjectPersistence.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test3() {
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        builder.checkDeltas(new IProject[]{this.project1, this.project2, this.project3, this.project4});
        try {
            this.file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.file2.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.file3.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.project1.build(10, this.getMonitor());
            ArrayList<IProject> received = builder.getReceivedDeltas();
            TestInterestingProjectPersistence.assertEquals((String)"1.0", (int)3, (int)received.size());
            TestInterestingProjectPersistence.assertTrue((String)"1.1", (boolean)received.contains(this.project1));
            TestInterestingProjectPersistence.assertTrue((String)"1.2", (boolean)received.contains(this.project2));
            TestInterestingProjectPersistence.assertTrue((String)"1.3", (!received.contains(this.project3) ? 1 : 0) != 0);
            TestInterestingProjectPersistence.assertTrue((String)"1.4", (boolean)received.contains(this.project4));
            ArrayList<IProject> empty = builder.getEmptyDeltas();
            TestInterestingProjectPersistence.assertEquals((String)"1.2", (int)1, (int)empty.size());
            TestInterestingProjectPersistence.assertTrue((String)"1.3", (boolean)empty.contains(this.project4));
            TestInterestingProjectPersistence.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestInterestingProjectPersistence.fail((String)"1.99", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestInterestingProjectPersistence.class);
    }
}

