/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.SnowBuilder;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestMissingBuilder
extends WorkspaceSessionTest {
    public TestMissingBuilder() {
    }

    public TestMissingBuilder(String name) {
        super(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasBuilder(IProject project, String builderId) {
        try {
            ICommand[] commands;
            ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                if (command.getBuilderName().equals(builderId)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)("Failed in hasBuilder(" + project.getName() + ", " + builderId + ")"), (Throwable)e);
        }
        return false;
    }

    protected InputStream projectFileWithoutWater() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.snowNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    protected void setAutoBuilding(boolean value) throws CoreException {
        IWorkspace workspace = TestMissingBuilder.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        workspace.setDescription(desc);
    }

    public void test1() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            this.setAutoBuilding(true);
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 1, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"0.99", (Throwable)e);
        }
        this.waitForBuild();
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        IFile descFile = project.getFile(".project");
        try {
            descFile.setContents(this.projectFileWithoutWater(), 1, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"1.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("1.0");
        TestMissingBuilder.assertTrue((String)"1.1", (boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        try {
            TestMissingBuilder.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"99.99", (Throwable)e);
        }
    }

    public void test2() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        TestMissingBuilder.assertTrue((String)"1.0", (boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        try {
            TestMissingBuilder.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"1.99", (Throwable)e);
        }
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.assertLifecycleEvents("1.1");
        try {
            TestMissingBuilder.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"99.99", (Throwable)e);
        }
    }

    public void test3() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        TestMissingBuilder.assertTrue((String)"1.0", (boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        try {
            TestMissingBuilder.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"1.99", (Throwable)e);
        }
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.assertLifecycleEvents("1.1");
        this.waitForBuild();
        builder.reset();
        builder.addExpectedLifecycleEvent("SnowBuild");
        try {
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 1, this.getMonitor());
        }
        catch (CoreException e) {
            TestMissingBuilder.fail((String)"2.99", (Throwable)e);
        }
        this.waitForBuild();
        builder.assertLifecycleEvents("2.0");
        TestMissingBuilder.assertTrue((String)"2.1", (boolean)builder.wasDeltaNull());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestMissingBuilder.class);
    }
}

