/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.usecase.ConcurrentOperation01;

public class ConcurrencyTest
extends ResourceTest {
    public ConcurrencyTest() {
    }

    public ConcurrencyTest(String name) {
        super(name);
    }

    protected void assertIsNotRunning(ConcurrentOperation01 op, String label) {
        int i = 0;
        while (i < 3) {
            try {
                Thread.sleep(100 * i);
            }
            catch (InterruptedException interruptedException) {}
            ConcurrencyTest.assertTrue((String)label, (!op.isRunning() ? 1 : 0) != 0);
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(ConcurrencyTest.class);
    }

    public void testConcurrentOperations() throws CoreException {
        IProject project = ConcurrencyTest.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        this.buildResources((IContainer)project, this.defineHierarchy());
        ConcurrentOperation01 op1 = new ConcurrentOperation01(ConcurrencyTest.getWorkspace());
        ConcurrentOperation01 op2 = new ConcurrentOperation01(ConcurrencyTest.getWorkspace());
        new Thread((Runnable)op1, "op1").start();
        ConcurrencyTest.assertTrue((String)"0.0", (boolean)op1.hasStarted());
        op1.returnWhenInSyncPoint();
        ConcurrencyTest.assertTrue((String)"0.1", (boolean)op1.isRunning());
        new Thread((Runnable)op2, "op2").start();
        ConcurrencyTest.assertTrue((String)"1.0", (boolean)op2.hasStarted());
        this.assertIsNotRunning(op2, "1.1");
        op1.proceed();
        op2.returnWhenInSyncPoint();
        ConcurrencyTest.assertTrue((String)"2.0", (boolean)op2.isRunning());
        op2.proceed();
        ConcurrencyTest.assertTrue((String)"2.1", (boolean)op1.getStatus().isOK());
        ConcurrencyTest.assertTrue((String)"2.2", (boolean)op2.getStatus().isOK());
        this.ensureDoesNotExistInWorkspace((IResource)ConcurrencyTest.getWorkspace().getRoot());
    }
}

