/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.usecase.IResourceTest;

public class IFileTest
extends IResourceTest {
    public IFileTest() {
        super(null);
    }

    public IFileTest(String name) {
        super(name);
    }

    protected void nonexistentFileFailureTests(IFile file, IFolder parent, IWorkspace wb) {
        String method = "nonexistentFileFailureTests(IFolder,IWorkspace)";
        try {
            if (file.isLocal(0)) {
                IFileTest.fail((String)(String.valueOf(method) + "1.1"));
            }
        }
        catch (RuntimeException runtimeException) {}
        try {
            if (file.isLocal(1)) {
                IFileTest.fail((String)(String.valueOf(method) + "1.2"));
            }
        }
        catch (RuntimeException runtimeException) {}
        try {
            if (file.isLocal(2)) {
                IFileTest.fail((String)(String.valueOf(method) + "1.3"));
            }
        }
        catch (RuntimeException runtimeException) {}
        this.commonFailureTestsForResource((IResource)file, false);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IFileTest.class.getName());
        suite.addTest((Test)new IFileTest("testFile"));
        return suite;
    }

    public void testFile() {
        IProgressMonitor monitor = null;
        IWorkspace workspace = IFileTest.getWorkspace();
        IProject proj = workspace.getRoot().getProject(PROJECT);
        try {
            proj.create(monitor);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            proj.open(monitor);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"2.2", (Throwable)e);
        }
        IFolder folder = proj.getFolder((IPath)new Path(FOLDER));
        IFile file = folder.getFile((IPath)new Path(FILE));
        IFileTest.assertTrue((String)"3.1", (!file.exists() ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"3.2", (boolean)file.getWorkspace().equals(workspace));
        IFileTest.assertTrue((String)"3.4", (boolean)file.getProject().equals((Object)proj));
        IFileTest.assertTrue((String)"3.5", (boolean)file.getParent().equals((Object)folder));
        IFileTest.assertTrue((String)"3.5", (file.getType() == 1 ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"3.6", (boolean)file.getFullPath().equals((Object)new Path("/" + PROJECT + "/" + FOLDER + "/" + FILE)));
        IFileTest.assertTrue((String)"3.7", (boolean)file.getName().equals(FILE));
        IFileTest.assertTrue((String)"3.8", (boolean)proj.getFolder((IPath)new Path(FOLDER)).equals((Object)folder));
        IFileTest.assertTrue((String)"3.9", (boolean)workspace.getRoot().getFile(file.getFullPath()).equals((Object)file));
        Path projRelativePath = new Path(String.valueOf(FOLDER) + "/" + FILE);
        IFileTest.assertTrue((String)"3.11", (boolean)proj.getFile((IPath)projRelativePath).equals((Object)file));
        IFileTest.assertTrue((String)"3.12", (boolean)folder.getFile((IPath)new Path(FILE)).equals((Object)file));
        IFileTest.assertTrue((String)"3.13", (!workspace.getRoot().exists(file.getFullPath()) ? 1 : 0) != 0);
        Path absolutePath = new Path(String.valueOf(proj.getLocation().toOSString()) + "/" + FOLDER + "/" + FILE);
        IFileTest.assertTrue((String)"3.14", (boolean)file.getLocation().equals((Object)absolutePath));
        IFileTest.assertTrue((String)"3.15", (boolean)file.getProjectRelativePath().equals((Object)new Path(String.valueOf(FOLDER) + "/" + FILE)));
        try {
            folder.create(false, true, monitor);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"4", (Throwable)e);
        }
        IFileTest.assertTrue((String)"5", (workspace.getRoot().findMember(file.getFullPath()) == null ? 1 : 0) != 0);
        this.nonexistentFileFailureTests(file, folder, workspace);
        try {
            file.create(this.getContents("0123456789"), false, monitor);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"6", (Throwable)e);
        }
        IFileTest.assertTrue((String)"7.0", (boolean)file.exists());
        IFileTest.assertTrue((String)"7.1", (boolean)folder.findMember(file.getName()).exists());
        IFileTest.assertTrue((String)"7.3", (boolean)workspace.getRoot().findMember(file.getFullPath()).equals((Object)file));
        IFileTest.assertTrue((String)"7.4", (boolean)workspace.getRoot().exists(file.getFullPath()));
        IFileTest.assertTrue((String)"7.5", (boolean)file.getLocation().equals((Object)absolutePath));
        try {
            IFileTest.assertTrue((String)"8.0", (file.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"8.1", (boolean)false);
        }
        try {
            file.setSessionProperty(Q_NAME_SESSION, (Object)STRING_VALUE);
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"8.2", (boolean)false);
        }
        try {
            IFileTest.assertTrue((String)"8.2", (boolean)file.getSessionProperty(Q_NAME_SESSION).equals(STRING_VALUE));
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"8.3", (boolean)false);
        }
        try {
            file.setSessionProperty(Q_NAME_SESSION, null);
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"8.4", (boolean)false);
        }
        try {
            IFileTest.assertTrue((String)"8.5", (file.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"8.6", (boolean)false);
        }
        IFileTest.assertTrue((String)"9.0", (boolean)file.isLocal(0));
        IFileTest.assertTrue((String)"9.1", (boolean)file.isLocal(1));
        IFileTest.assertTrue((String)"9.2", (boolean)file.isLocal(2));
        IFileTest.assertTrue((String)"9.3", (boolean)proj.isLocal(2));
        IFileTest.assertTrue((String)"9.5", (boolean)folder.isLocal(1));
        IFileTest.assertTrue((String)"9.6", (boolean)folder.isLocal(2));
        try {
            file.delete(false, monitor);
        }
        catch (CoreException e) {
            IFileTest.fail((String)"10.0", (Throwable)e);
        }
        IFileTest.assertTrue((String)"11.1", (!file.exists() ? 1 : 0) != 0);
        try {
            IFileTest.assertTrue((String)"11.2", (folder.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFileTest.assertTrue((String)"11.3", (boolean)false);
        }
        IFileTest.assertTrue((String)"11.4", (workspace.getRoot().findMember(file.getFullPath()) == null ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"11.5", (!workspace.getRoot().exists(file.getFullPath()) ? 1 : 0) != 0);
        IFileTest.assertTrue((String)"11.6", (boolean)file.getLocation().equals((Object)absolutePath));
        this.nonexistentFileFailureTests(file, folder, workspace);
        try {
            proj.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IFileTest.fail((String)"12.0", (Throwable)e);
        }
    }
}

