/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.detailpanes;

import org.eclipse.debug.examples.core.midi.launcher.TempoControl;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbenchPartSite;

public class TempoSliderDetailPane
implements IDetailPane {
    private Slider fSlider;
    private TempoControl fControl;

    public Control createControl(Composite parent) {
        this.fSlider = new Slider(parent, 256);
        this.fSlider.setMinimum(20);
        this.fSlider.setMaximum(500);
        this.fSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = TempoSliderDetailPane.this.fSlider.getSelection();
                if (TempoSliderDetailPane.this.fControl != null) {
                    TempoSliderDetailPane.this.fControl.setValue(Integer.toString(selection));
                }
            }
        });
        return this.fSlider;
    }

    public void display(IStructuredSelection selection) {
        this.fControl = null;
        if (selection == null || selection.isEmpty()) {
            this.fSlider.setEnabled(false);
        } else {
            this.fSlider.setEnabled(true);
            this.fControl = (TempoControl)selection.getFirstElement();
            int bpm = (int)this.fControl.getSequencer().getTempoInBPM();
            this.fSlider.setSelection(bpm);
        }
    }

    public void dispose() {
    }

    public String getDescription() {
        return "Tempo (beats per minute)";
    }

    public String getID() {
        return "TEMPO_SLIDER";
    }

    public String getName() {
        return "Tempo Slider (BPM)";
    }

    public void init(IWorkbenchPartSite partSite) {
    }

    public boolean setFocus() {
        this.fSlider.setFocus();
        return true;
    }
}

