/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.launcher;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.examples.ui.pda.DebugUIPlugin;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class PDAMainTab
extends AbstractLaunchConfigurationTab {
    private Text fProgramText;
    private Button fProgramButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label programLabel = new Label(comp, 0);
        programLabel.setText("&Program:");
        GridData gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.fProgramText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fProgramText.setLayoutData((Object)gd);
        this.fProgramText.setFont(font);
        this.fProgramText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDAMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProgramButton = this.createPushButton(comp, "&Browse...", null);
        this.fProgramButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDAMainTab.this.browsePDAFiles();
            }
        });
    }

    protected void browsePDAFiles() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("PDA Program");
        dialog.setMessage("Select PDA Program");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.fProgramText.setText(file.getFullPath().toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String program = null;
            program = configuration.getAttribute("pda.debugModel.ATTR_PDA_PROGRAM", null);
            if (program != null) {
                this.fProgramText.setText(program);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String program = this.fProgramText.getText().trim();
        if (program.length() == 0) {
            program = null;
        }
        configuration.setAttribute("pda.debugModel.ATTR_PDA_PROGRAM", program);
        IResource[] resources = null;
        if (program != null) {
            Path path = new Path(program);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                resources = new IResource[]{res};
            }
        }
        configuration.setMappedResources(resources);
    }

    public String getName() {
        return "Main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        this.setMessage(null);
        String text = this.fProgramText.getText();
        if (text.length() > 0) {
            Path path = new Path(text);
            IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (member == null) {
                this.setErrorMessage("Specified program does not exist");
                return false;
            }
            if (member.getType() != 1) {
                this.setWarningMessage("Specified program is not a file.");
            }
        } else {
            this.setMessage("Specify a program");
        }
        return true;
    }

    public Image getImage() {
        return DebugUIPlugin.getDefault().getImageRegistry().get("IMB_OBJ_PDA");
    }
}

