/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.eclipse.debug.tests.console.TestHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;

public class ConsoleManagerTests
extends TestCase {
    private static final String INTROVIEW_ID = "org.eclipse.ui.internal.introview";
    private ExecutorService executorService;
    private IConsoleManager manager;
    private int count;
    private CountDownLatch latch;
    private ConsoleMock[] consoles;
    ConsoleMock firstConsole;

    protected void setUp() throws Exception {
        super.setUp();
        ConsoleManagerTests.assertNotNull((String)("Must run in UI thread, but was in: " + Thread.currentThread().getName()), (Object)Display.getCurrent());
        this.count = 20;
        this.latch = new CountDownLatch(this.count);
        this.executorService = Executors.newFixedThreadPool(this.count);
        this.manager = ConsolePlugin.getDefault().getConsoleManager();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.hideWelcomePage(activePage);
        TestHelper.processUIEvents(100L);
        this.consoles = new ConsoleMock[this.count];
        int i = 0;
        while (i < this.count) {
            ConsoleMock console;
            this.consoles[i] = console = new ConsoleMock(i + 1);
            ++i;
        }
        this.manager.addConsoles((IConsole[])this.consoles);
        IViewPart consoleView = activePage.showView("org.eclipse.ui.console.ConsoleView");
        activePage.activate((IWorkbenchPart)consoleView);
        TestHelper.processUIEvents(100L);
        this.firstConsole = new ConsoleMock(0);
        this.manager.addConsoles((IConsole[])new ConsoleMock[]{this.firstConsole});
        this.manager.showConsoleView((IConsole)this.firstConsole);
        TestHelper.waitForJobs();
        TestHelper.processUIEvents(100L);
        ConsoleMock.allShownConsoles.set(0);
    }

    protected void tearDown() throws Exception {
        this.executorService.shutdownNow();
        this.manager.removeConsoles((IConsole[])this.consoles);
        this.manager.removeConsoles((IConsole[])new ConsoleMock[]{this.firstConsole});
        TestHelper.processUIEvents(100L);
        super.tearDown();
    }

    private void hideWelcomePage(IWorkbenchPage activePage) {
        IViewReference[] refs = activePage.getViewReferences();
        IViewPart intro = null;
        IViewReference[] iViewReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (INTROVIEW_ID.equals(ref.getId())) {
                intro = ref.getView(false);
            }
            ++n2;
        }
        if (intro != null) {
            activePage.hideView(intro);
            TestHelper.processUIEvents(100L);
        }
    }

    public void testShowAllConsoles() throws Exception {
        ConsoleMock[] consoleMockArray = this.consoles;
        int n = this.consoles.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleMock console = consoleMockArray[n2];
            this.showConsole(console);
            ++n2;
        }
        System.out.println("All tasks scheduled, processing UI events now...");
        TestHelper.processUIEvents(1000L);
        System.out.println("Waiting on jobs now...");
        TestHelper.waitForJobs();
        System.out.println("Done with jobs, processing UI events again...");
        TestHelper.processUIEvents(3000L);
        this.executorService.shutdown();
        System.out.println("Waiting on execution service to finish...");
        boolean OK = this.waitForExecutorService();
        if (!OK) {
            System.out.println("Timed out...");
            TestHelper.processUIEvents(10000L);
            ConsoleManagerTests.assertTrue((String)"Timeout occurred while waiting on console to be shown", (boolean)this.waitForExecutorService());
        } else {
            System.out.println("Done waiting on execution service to finish");
        }
        int shown = ConsoleMock.allShownConsoles.intValue();
        ConsoleManagerTests.assertEquals((String)("Only " + shown + " consoles were shown from " + this.count), (int)this.count, (int)shown);
    }

    private boolean waitForExecutorService() throws InterruptedException {
        int i = 0;
        while (i < 60) {
            if (this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                return true;
            }
            TestHelper.processUIEvents(100L);
            ++i;
        }
        return false;
    }

    private void showConsole(final ConsoleMock console) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ConsoleManagerTests.this.latch.countDown();
                try {
                    ConsoleManagerTests.this.latch.await(1L, TimeUnit.MINUTES);
                    System.out.println("Requesting to show: " + console);
                    ConsoleManagerTests.this.manager.showConsoleView((IConsole)console);
                    TestHelper.waitForJobs();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.interrupted();
                }
            }
        });
    }

    static final class ConsoleMock
    implements IConsole {
        MessagePage page;
        final AtomicInteger showCalled;
        final int number;
        static final AtomicInteger allShownConsoles = new AtomicInteger();

        public ConsoleMock(int number) {
            this.number = number;
            this.showCalled = new AtomicInteger();
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
        }

        public String getType() {
            return null;
        }

        public String getName() {
            return this.toString();
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
        }

        public IPageBookViewPage createPage(IConsoleView view) {
            this.page = new MessagePage(){

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    this.getControl().addListener(22, new Listener(){

                        public void handleEvent(Event event) {
                            int count = (this).ConsoleMock.this.showCalled.incrementAndGet();
                            if (count == 1) {
                                count = allShownConsoles.incrementAndGet();
                                System.out.println("Shown: " + ConsoleMock.this + ", overall: " + count);
                            }
                        }
                    });
                }
            };
            this.page.setMessage(this.toString());
            return this.page;
        }

        public String toString() {
            return "mock #" + this.number;
        }
    }
}

