/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.eclipse.debug.tests.console.TestHelper;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class ConsoleTests
extends TestCase {
    public ConsoleTests() {
        super("ConsoleTests");
    }

    public ConsoleTests(String name) {
        super(name);
    }

    public void testConsoleOutputStreamEncoding() throws IOException, InterruptedException {
        String testString = "abc\u00e4\u00f6\u00fcdef";
        byte[] testStringBuffer = testString.getBytes(StandardCharsets.UTF_8);
        TestCase.assertEquals((String)("Test string \"" + testString + "\" should consist of 12 UTF-8 bytes"), (int)12, (int)testStringBuffer.length);
        MessageConsole console = new MessageConsole("Test Console", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        TestHelper.waitForJobs();
        TestCase.assertEquals((String)"Document should be empty", (String)"", (String)document.get());
        Throwable throwable = null;
        Object var6_7 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write(testStringBuffer, 0, 6);
            TestHelper.waitForJobs();
            TestCase.assertEquals((String)"First 4 chars should be written", (String)testString.substring(0, 4), (String)document.get());
            outStream.write(testStringBuffer, 6, 6);
            TestHelper.waitForJobs();
            TestCase.assertEquals((String)"whole test string should be written", (String)testString, (String)document.get());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TestHelper.waitForJobs();
        TestCase.assertEquals((String)"closing the stream should not alter the document", (String)testString, (String)document.get());
    }

    public void testConsoleOutputStreamLastR() throws IOException, InterruptedException {
        String testString = "a\r";
        byte[] testStringBuffer = testString.getBytes(StandardCharsets.UTF_8);
        TestCase.assertEquals((String)("Test string \"" + testString + "\" should consist of 2 UTF-8 bytes"), (int)2, (int)testStringBuffer.length);
        MessageConsole console = new MessageConsole("Test Console 2", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        TestHelper.waitForJobs();
        TestCase.assertEquals((String)"Document should be empty", (String)"", (String)document.get());
        Throwable throwable = null;
        Object var6_7 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write(testStringBuffer);
            TestHelper.waitForJobs();
            TestCase.assertEquals((String)"First char should be written", (String)testString.substring(0, 1), (String)document.get());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TestHelper.waitForJobs();
        TestCase.assertEquals((String)"closing the stream should write the pending \\r", (String)testString, (String)document.get());
    }

    public void testConsoleOutputStreamDocumentClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 3", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("write1");
            document.getDocumentPartitioner().disconnect();
            try {
                outStream.write("write2");
                TestCase.fail((String)"IOException with message \"Document is closed\" expected");
            }
            catch (IOException ioe) {
                TestCase.assertEquals((String)"Document is closed", (String)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testConsoleOutputStreamClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 4", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("test1".getBytes(StandardCharsets.UTF_8));
            outStream.close();
            try {
                outStream.write("test2".getBytes(StandardCharsets.UTF_8));
                TestCase.fail((String)"IOException with message \"Output Stream is closed\" expected");
            }
            catch (IOException ioe) {
                TestCase.assertEquals((String)"Output Stream is closed", (String)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testConsoleOutputStreamDocumentStreamClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 5", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("write1");
            document.getDocumentPartitioner().disconnect();
            try {
                outStream.write("write2");
                TestCase.fail((String)"IOException with message \"Document is closed\" expected");
            }
            catch (IOException ioe) {
                TestCase.assertEquals((String)"Document is closed", (String)ioe.getMessage());
            }
            try {
                outStream.write("write3");
                TestCase.fail((String)"IOException with message \"Output Stream is closed\" expected");
            }
            catch (IOException ioe) {
                TestCase.assertEquals((String)"Output Stream is closed", (String)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

