/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.breakpoint;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsComparator;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;

public class BreakpointOrderingTests
extends TestCase {
    StructuredViewer fTestViewer = new StructuredViewer(){

        public IBaseLabelProvider getLabelProvider() {
            return BreakpointOrderingTests.this.fDebugModelPres;
        }

        protected Widget doFindInputItem(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }

        protected Widget doFindItem(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }

        protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        protected List getSelectionFromWidget() {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }

        protected void internalRefresh(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public void reveal(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        protected void setSelectionToWidget(List l, boolean reveal) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public Control getControl() {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }
    };
    IDebugModelPresentation fDebugModelPres = new IDebugModelPresentation(){

        public void computeDetail(IValue value, IValueDetailListener listener) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public Image getImage(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }

        public String getText(Object element) {
            BreakpointOrderingTests.assertTrue((String)"Unexpected element", (boolean)(element instanceof TestBreakpoint));
            return ((TestBreakpoint)element).getText();
        }

        public void setAttribute(String attribute, Object value) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public void addListener(ILabelProviderListener listener) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public void dispose() {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public boolean isLabelProperty(Object element, String property) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public String getEditorId(IEditorInput input, Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }

        public IEditorInput getEditorInput(Object element) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }
    };

    public BreakpointOrderingTests(String name) {
        super(name);
    }

    TestBreakpoint[] createTestBreakpoints0() {
        TestBreakpoint[] fTestBps = new TestBreakpoint[]{new TestBreakpoint(""), new TestBreakpoint("/file/text.c"), new TestBreakpoint("/file/text.c:1"), new TestLineBreakpoint("", 0), new TestLineBreakpoint("/file/text.c", 0), new TestLineBreakpoint("/file/text.c", 1), new TestLineBreakpoint("/file/text.c:", 0), new TestLineBreakpoint("/file/text.c:0", 0), new TestLineBreakpoint("/file/text.c:1", 1), new TestLineBreakpoint("/file/text.c:0002", 2), new TestLineBreakpoint("/file/text.c:3xxx", 3), new TestLineBreakpoint("/file/text.c:10xxx", 10), new TestLineBreakpoint("/file/text.c:a_01", 1), new TestLineBreakpoint("/file/text.c:a_01a", 1), new TestLineBreakpoint("/file/text.c:a_09", 9), new TestLineBreakpoint("/file/text.c:a_09a", 9), new TestLineBreakpoint("/file/text.c:a_011", 11), new TestLineBreakpoint("/file/text.c:a_011a", 11), new TestLineBreakpoint("/file/text.c:y", 0)};
        return fTestBps;
    }

    TestBreakpoint[] createTestBreakpoints1() {
        TestBreakpoint[] fTestBps = new TestBreakpoint[]{new TestLineBreakpoint("0", 0), new TestLineBreakpoint("1", 1), new TestLineBreakpoint("1_a", 1), new TestLineBreakpoint("001_b", 1), new TestLineBreakpoint("01_c", 1), new TestLineBreakpoint("3", 3), new TestLineBreakpoint("10", 10), new TestLineBreakpoint("11", 11), new TestLineBreakpoint("20", 20), new TestLineBreakpoint("110", 110), new TestLineBreakpoint("112", 112), new TestLineBreakpoint("112a", 112), new TestLineBreakpoint("112b", 112)};
        return fTestBps;
    }

    TestBreakpoint[] createTestBreakpoints2() {
        TestBreakpoint[] fTestBps = new TestBreakpoint[]{new TestLineBreakpoint("0", 0), new TestLineBreakpoint("00", 0), new TestLineBreakpoint("0000", 0), new TestLineBreakpoint("0001", 1), new TestLineBreakpoint("0010", 10), new TestLineBreakpoint("1000", 1000), new TestLineBreakpoint("10000", 10000)};
        return fTestBps;
    }

    TestBreakpoint[] createTestBreakpoints3() {
        TestBreakpoint[] fTestBps = new TestBreakpoint[]{new TestLineBreakpoint(":a", 0), new TestLineBreakpoint("c:\\file\\text.c:1", 1), new TestLineBreakpoint("c:\\file\\text.c:2", 2), new TestLineBreakpoint("d:\\file\\text.c:3", 3)};
        return fTestBps;
    }

    public void testBreakpointOrdering0() throws CoreException {
        this.executeTest(this.createTestBreakpoints0());
    }

    public void testBreakpointOrdering1() throws CoreException {
        this.executeTest(this.createTestBreakpoints1());
    }

    public void testBreakpointOrdering2() throws CoreException {
        this.executeTest(this.createTestBreakpoints2());
    }

    public void testBreakpointOrdering3() throws CoreException {
        this.executeTest(this.createTestBreakpoints3());
    }

    /*
     * Unable to fully structure code
     */
    void executeTest(TestBreakpoint[] testBps) throws CoreException {
        bpCompare = new BreakpointsComparator();
        try {
            failed = false;
            inner = 0;
            while (inner < testBps.length) {
                testInner = testBps[inner];
                outer = 0;
                while (outer < testBps.length) {
                    testOuter = testBps[outer];
                    res = bpCompare.compare((Viewer)this.fTestViewer, (Object)testInner, (Object)testOuter);
                    equalCheck = res == 0 == (inner == outer);
                    v0 = ltCheck = res < 0 == inner < outer;
                    if (!equalCheck) {
                        System.err.println("Equal Comparison in between " + inner + " and " + outer + " (" + testBps[inner].getText() + " and " + testBps[outer].getText() + ") failed");
                        failed = true;
                    }
                    if (!ltCheck) {
                        System.err.println("Less Comparison in between " + inner + " and " + outer + " (" + testBps[inner].getText() + " and " + testBps[outer].getText() + ") failed");
                        failed = true;
                    }
                    ++outer;
                }
                ++inner;
            }
            BreakpointOrderingTests.assertFalse((boolean)failed);
        }
        finally {
            index = 0;
            ** while (index < testBps.length)
        }
lbl-1000:
        // 1 sources

        {
            testBps[index].delete();
            ++index;
            continue;
        }
lbl31:
        // 1 sources

    }

    static class TestBreakpoint
    implements IBreakpoint {
        private final String fText;
        private IMarker fMarker = null;

        TestBreakpoint(String text) {
            this(text, IBreakpoint.BREAKPOINT_MARKER);
        }

        TestBreakpoint(String text, String markerType) {
            this.fText = text;
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            IWorkspaceRunnable wr = new IWorkspaceRunnable((IResource)resource, markerType){
                private final /* synthetic */ IResource val$resource;
                private final /* synthetic */ String val$markerType;
                {
                    this.val$resource = iResource;
                    this.val$markerType = string;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    TestBreakpoint.this.setMarker(this.val$resource.createMarker(this.val$markerType));
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(wr, null);
            }
            catch (CoreException e) {
                BreakpointOrderingTests.fail((String)("Unexpected exception: " + e.toString()));
            }
        }

        void ReportFailure(String msg) throws CoreException {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.debug.tests", msg));
        }

        String getText() {
            return this.fText;
        }

        public void delete() throws CoreException {
            this.fMarker.delete();
        }

        public IMarker getMarker() {
            return this.fMarker;
        }

        public String getModelIdentifier() {
            return "Test";
        }

        public boolean isEnabled() throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return false;
        }

        public boolean isPersisted() throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return false;
        }

        public boolean isRegistered() throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return false;
        }

        public void setEnabled(boolean enabled) throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public void setMarker(IMarker marker) throws CoreException {
            BreakpointOrderingTests.assertTrue((this.fMarker == null && marker != null ? 1 : 0) != 0);
            this.fMarker = marker;
        }

        public void setPersisted(boolean registered) throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public void setRegistered(boolean registered) throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
        }

        public <T> T getAdapter(Class<T> adapter) {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return null;
        }
    }

    static class TestLineBreakpoint
    extends TestBreakpoint
    implements ILineBreakpoint {
        private final int fLineNum;

        TestLineBreakpoint(String text, int lineNum) {
            super(text, IBreakpoint.LINE_BREAKPOINT_MARKER);
            this.fLineNum = lineNum;
        }

        public int getLineNumber() throws CoreException {
            return this.fLineNum;
        }

        public int getCharEnd() throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return 0;
        }

        public int getCharStart() throws CoreException {
            BreakpointOrderingTests.fail((String)"not implemented in test");
            return 0;
        }
    }
}

