/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.tests.launching.DebugFileSystem;

public class DebugFileStore
extends FileStore {
    private final URI uri;

    public DebugFileStore(URI id) {
        this.uri = id;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        URI[] uris = DebugFileSystem.getDefault().getFileURIs();
        ArrayList<String> children = new ArrayList<String>();
        IPath me = this.getPath();
        int i = 0;
        while (i < uris.length) {
            URI id = uris[i];
            Path path = new Path(id.getPath());
            if (path.segmentCount() > 0 && path.removeLastSegments(1).equals((Object)me)) {
                children.add(path.lastSegment());
            }
            ++i;
        }
        return children.toArray(new String[children.size()]);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        byte[] contents = DebugFileSystem.getDefault().getContents(this.toURI());
        FileInfo info = new FileInfo();
        info.setName(this.getName());
        info.setAttribute(2, false);
        if (contents == null) {
            info.setExists(false);
            info.setLength(0L);
        } else {
            info.setExists(true);
            info.setLength((long)contents.length);
            info.setDirectory(contents == DebugFileSystem.DIRECTORY_BYTES);
            if (info.isDirectory()) {
                info.setAttribute(4, true);
            }
        }
        return info;
    }

    public IFileStore getChild(String name) {
        try {
            return new DebugFileStore(new URI(this.getFileSystem().getScheme(), this.getPath().append(name).toString(), null));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getName() {
        IPath path = this.getPath();
        if (path.segmentCount() > 0) {
            return path.lastSegment();
        }
        return "";
    }

    private IPath getPath() {
        URI me = this.toURI();
        Path path = new Path(me.getPath());
        return path;
    }

    public IFileStore getParent() {
        IPath path = this.getPath();
        if (path.segmentCount() > 0) {
            try {
                return new DebugFileStore(new URI(this.getFileSystem().getScheme(), path.removeLastSegments(1).toString(), null));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        byte[] contents = DebugFileSystem.getDefault().getContents(this.toURI());
        if (contents != null) {
            return new ByteArrayInputStream(contents);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.debug.tests", "File does not exist: " + this.toURI()));
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new DebugOutputStream();
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        IFileInfo info = this.fetchInfo();
        if (info.exists()) {
            if (!info.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.debug.tests", "mkdir failed - file already exists with name: " + this.toURI()));
            }
        } else {
            IFileStore parent = this.getParent();
            if (parent.fetchInfo().exists()) {
                DebugFileSystem.getDefault().setContents(this.toURI(), DebugFileSystem.DIRECTORY_BYTES);
            } else {
                if ((options & 4) > 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.debug.tests", "mkdir failed - parent does not exist: " + this.toURI()));
                }
                parent.mkdir(0, null);
            }
        }
        return this;
    }

    public URI toURI() {
        return this.uri;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        DebugFileSystem.getDefault().delete(this.toURI());
    }

    class DebugOutputStream
    extends ByteArrayOutputStream {
        DebugOutputStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            DebugFileSystem.getDefault().setContents(DebugFileStore.this.toURI(), this.toByteArray());
        }
    }
}

