/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.internal.core.RefreshScopeComparator;
import org.eclipse.debug.tests.TestsPlugin;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RefreshTabTests
extends AbstractLaunchTest {
    public RefreshTabTests(String name) {
        super(name);
    }

    protected void setSelection(IResource resource) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        RefreshTabTests.assertNotNull((String)"The active workbench page should not be null", (Object)page);
        try {
            IViewPart part = page.showView("org.eclipse.ui.views.ResourceNavigator");
            IWorkbenchPartSite site = part.getSite();
            RefreshTabTests.assertNotNull((String)"The part site for org.eclipse.ui.views.ResourceNavigator should not be null ", (Object)site);
            ISelectionProvider provider = site.getSelectionProvider();
            RefreshTabTests.assertNotNull((String)"the selection provider should not be null for org.eclipse.ui.views.ResourceNavigator", (Object)provider);
            provider.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        catch (PartInitException partInitException) {
            RefreshTabTests.assertNotNull((String)"Failed to open navigator view", null);
        }
    }

    public void testSelectedResource() throws CoreException {
        String scope = "${resource}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)resource, (Object)result[0]);
    }

    public void testSelectionsFolder() throws CoreException {
        String scope = "${container}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)resource.getParent(), (Object)result[0]);
    }

    public void testSelectionsProject() throws CoreException {
        String scope = "${project}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)resource.getProject(), (Object)result[0]);
    }

    public void testWorkspaceScope() throws CoreException {
        String scope = "${workspace}";
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)ResourcesPlugin.getWorkspace().getRoot(), (Object)result[0]);
    }

    public void testSpecificResource() throws CoreException {
        String scope = "${resource:/RefreshTabTests/some.file}";
        IFile resource = this.getProject().getFile("some.file");
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)resource, (Object)result[0]);
    }

    public void testWorkingSet() throws CoreException {
        String scope = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        IFile resource = this.getProject().getFile("some.file");
        IResource[] result = RefreshTab.getRefreshResources((String)scope);
        RefreshTabTests.assertNotNull((Object)result);
        RefreshTabTests.assertEquals((int)1, (int)result.length);
        RefreshTabTests.assertEquals((Object)resource, (Object)result[0]);
    }

    protected IProject getProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("RefreshTabTests");
        if (!project.exists()) {
            project = TestsPlugin.createProject("RefreshTabTests");
            IFolder folder = project.getFolder("src");
            folder.create(false, true, null);
            IFile file = project.getFile("some.file");
            file.create((InputStream)new ByteArrayInputStream("test file".getBytes()), false, null);
        }
        return project;
    }

    public void testRefreshScopeComparator() throws CoreException {
        String oldStyle = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        String newStyle = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<resources>\n<item path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</resources>}";
        RefreshTabTests.assertEquals((String)"Comparator should return 0", (int)0, (int)new RefreshScopeComparator().compare(oldStyle, newStyle));
    }

    public void testResourceMemento() throws CoreException {
        IResource[] resources = new IResource[]{this.getProject(), this.getProject().getFile("not.exist"), this.getProject().getFile("some.file")};
        String memento = RefreshUtil.toMemento((IResource[])resources);
        IResource[] restore = RefreshUtil.toResources((String)memento);
        RefreshTabTests.assertEquals((int)resources.length, (int)restore.length);
        RefreshTabTests.assertEquals((Object)resources[0], (Object)restore[0]);
        RefreshTabTests.assertEquals((Object)resources[1], (Object)restore[1]);
        RefreshTabTests.assertEquals((Object)resources[2], (Object)restore[2]);
    }

    public void testEmptyResourceSet() throws CoreException {
        String memento = RefreshUtil.toMemento((IResource[])new IResource[0]);
        IResource[] resources = RefreshUtil.toResources((String)memento);
        RefreshTabTests.assertNotNull((Object)resources);
        RefreshTabTests.assertEquals((String)"Should be empty", (int)0, (int)resources.length);
    }
}

