/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DependenciesLeakTest {
    static final String LEGACY_H_ID = "legacy::handler::";
    private IEclipseContext windowContext;
    private IEclipseContext perspectiveContext;
    private IEclipseContext partContext;

    @Before
    public void setUp() throws Exception {
        this.windowContext = EclipseContextFactory.create((String)"Window");
        this.perspectiveContext = this.windowContext.createChild("Perspective");
        this.partContext = this.perspectiveContext.createChild("Part");
    }

    @Test
    public void testBug() {
        String handler = "<foo.bar.handler>";
        this.windowContext.set("legacy::handler::foo.bar", (Object)handler);
        this.windowContext.set("foo.bar", (Object)new HandlerSelectionFunction("foo.bar"));
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
        Object object = this.partContext.get("foo.bar");
        Assert.assertEquals((Object)object, (Object)handler);
        this.windowContext.set("foo.bar", null);
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
    }

    @Test
    public void testInvalidateDirectly() {
        this.windowContext.set("x", (Object)42);
        this.windowContext.set("y", (Object)11);
        this.windowContext.set("some.handler", (Object)new AddContextFunction());
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
        Object object = this.partContext.get("some.handler");
        Assert.assertEquals((Object)object, (Object)53);
        this.windowContext.set("some.handler", null);
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
    }

    private void assertNoListeners(IEclipseContext context) {
        EclipseContext c = (EclipseContext)context;
        try {
            Assert.assertTrue((boolean)c.getListeners().isEmpty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class HandlerSelectionFunction
    extends ContextFunction {
        private String commandId;

        public HandlerSelectionFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context, String contextKey) {
            return context.get(DependenciesLeakTest.LEGACY_H_ID + this.commandId);
        }

        public String toString() {
            return "HandlerSelectionFunction [commandId=" + this.commandId + "]";
        }
    }
}

