/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EclipseContextTest {
    private IEclipseContext context;
    private IEclipseContext parentContext;
    private int runCounter;

    @Before
    public void setUp() throws Exception {
        this.parentContext = EclipseContextFactory.create((String)"EclipseContextTest-parent");
        this.context = this.parentContext.createChild("EclipseContextTest");
        this.runCounter = 0;
    }

    @Test
    public void testContainsKey() {
        Assert.assertFalse((String)"1.0", (boolean)this.context.containsKey("function"));
        Assert.assertFalse((String)"1.1", (boolean)this.context.containsKey("separator"));
        this.context.set("separator", (Object)",");
        Assert.assertTrue((String)"2.1", (boolean)this.context.containsKey("separator"));
        this.context.set("separator", null);
        Assert.assertTrue((String)"3.0", (boolean)this.context.containsKey("separator"));
        this.context.remove("separator");
        Assert.assertFalse((String)"4.0", (boolean)this.context.containsKey("separator"));
    }

    @Test
    public void testGet() {
        Assert.assertNull((Object)this.context.get("foo"));
        this.context.set("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        Assert.assertNull((Object)this.parentContext.get("foo"));
        this.context.remove("foo");
        Assert.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        Assert.assertNull((Object)this.context.get("foo"));
        this.context.set("bar", (Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)this.context.get("foo"));
    }

    @Test
    public void testGetLocal() {
        Assert.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.context.getLocal("foo"));
        Assert.assertNull((Object)this.parentContext.getLocal("foo"));
        this.context.remove("foo");
        Assert.assertNull((Object)this.context.getLocal("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assert.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        Assert.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("bar", (Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)this.context.getLocal("foo"));
    }

    @Test
    public void testDisposeRemovesParentReference() {
        Assert.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.dispose();
        Assert.assertNull((Object)this.context.get("foo"));
        Assert.assertTrue((boolean)((EclipseContext)this.parentContext).getChildren().isEmpty());
    }

    @Test
    public void testDisposeClearsNotifyOnDisposalSet() {
        ((EclipseContext)this.context).notifyOnDisposal(new IContextDisposalListener(){

            public void disposed(IEclipseContext context) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
            }
        });
        this.context.dispose();
        Assert.assertEquals((long)1L, (long)this.runCounter);
        this.context.dispose();
        Assert.assertEquals((long)1L, (long)this.runCounter);
    }

    @Test
    public void testContextFunctionInParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assert.assertEquals((long)6L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)child.get("sum")).intValue());
        child.set("x", (Object)5);
        Assert.assertEquals((long)6L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)child.get("sum")).intValue());
        child.remove("x");
        Assert.assertEquals((long)6L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)child.get("sum")).intValue());
        parent.set("x", (Object)10);
        Assert.assertEquals((long)13L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)child.get("sum")).intValue());
    }

    @Test
    public void testRunAndTrack() {
        final Object[] value = new Object[1];
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                value[0] = context.get("foo");
                return true;
            }
        });
        Assert.assertEquals((long)1L, (long)this.runCounter);
        Assert.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        Assert.assertEquals((long)2L, (long)this.runCounter);
        Assert.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        Assert.assertEquals((long)3L, (long)this.runCounter);
        Assert.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return context.get("bar");
            }
        });
        Assert.assertEquals((long)4L, (long)this.runCounter);
        Assert.assertEquals(null, (Object)value[0]);
        this.context.set("bar", (Object)"baz");
        Assert.assertEquals((long)5L, (long)this.runCounter);
        Assert.assertEquals((Object)"baz", (Object)value[0]);
        this.context.set("bar", (Object)"baf");
        Assert.assertEquals((long)6L, (long)this.runCounter);
        Assert.assertEquals((Object)"baf", (Object)value[0]);
        this.context.remove("bar");
        Assert.assertEquals((long)7L, (long)this.runCounter);
        Assert.assertEquals(null, (Object)value[0]);
        this.parentContext.set("bar", (Object)"bam");
        Assert.assertEquals((long)8L, (long)this.runCounter);
        Assert.assertEquals((Object)"bam", (Object)value[0]);
    }

    @Test
    public void testRegisterRunAndTrackTwice() {
        final Object[] value = new Object[1];
        RunAndTrack runnable = new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                value[0] = context.get("foo");
                return true;
            }
        };
        this.context.runAndTrack(runnable);
        Assert.assertEquals((long)1L, (long)this.runCounter);
        this.context.runAndTrack(runnable);
        Assert.assertEquals((long)2L, (long)this.runCounter);
        Assert.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        Assert.assertEquals((long)3L, (long)this.runCounter);
        Assert.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        Assert.assertEquals((long)4L, (long)this.runCounter);
    }

    @Test
    public void testRunAndTrackMultipleValues() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        final IEclipseContext child = parent.createChild("ChildContext");
        parent.set("parentValue", (Object)"x");
        child.set("childValue", (Object)"x");
        RunAndTrack runnable = new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                if (EclipseContextTest.this.runCounter < 2) {
                    child.get("childValue");
                    return true;
                }
                if (EclipseContextTest.this.runCounter < 3) {
                    child.get("parentValue");
                    return true;
                }
                return false;
            }
        };
        child.runAndTrack(runnable);
        Assert.assertEquals((long)1L, (long)this.runCounter);
        child.set("childValue", (Object)"z");
        Assert.assertEquals((long)2L, (long)this.runCounter);
        parent.set("parentValue", (Object)"z");
        Assert.assertEquals((long)3L, (long)this.runCounter);
    }

    @Test
    public void testModify() {
        IEclipseContext grandParent = EclipseContextFactory.create();
        IEclipseContext parent = grandParent.createChild();
        IEclipseContext child = parent.createChild();
        child.set("a", (Object)"a1");
        parent.set("b", (Object)"b2");
        grandParent.set("c", (Object)"c3");
        child.declareModifiable("a");
        parent.declareModifiable("b");
        grandParent.declareModifiable("c");
        Assert.assertNull((Object)grandParent.get("b"));
        Assert.assertEquals((Object)"b2", (Object)parent.get("b"));
        Assert.assertEquals((Object)"b2", (Object)child.get("b"));
        Assert.assertNull((Object)child.getLocal("b"));
        child.modify("b", (Object)"abc");
        Assert.assertFalse((boolean)grandParent.containsKey("b"));
        Assert.assertEquals((Object)"abc", (Object)parent.get("b"));
        Assert.assertEquals((Object)"abc", (Object)child.get("b"));
        Assert.assertNull((Object)child.getLocal("b"));
        child.modify("d", (Object)"123");
        Assert.assertFalse((boolean)grandParent.containsKey("d"));
        Assert.assertFalse((boolean)parent.containsKey("d"));
        Assert.assertNull((Object)parent.get("d"));
        Assert.assertEquals((Object)"123", (Object)child.get("d"));
        grandParent.modify("c", (Object)"cNew");
        Assert.assertTrue((boolean)grandParent.containsKey("c"));
        Assert.assertEquals((Object)"cNew", (Object)grandParent.get("c"));
        Assert.assertNull((Object)parent.getLocal("c"));
        Assert.assertNull((Object)child.getLocal("c"));
        Assert.assertTrue((boolean)child.containsKey("c"));
        child.modify("a", (Object)"aNew");
        Assert.assertTrue((boolean)child.containsKey("a"));
        Assert.assertFalse((boolean)parent.containsKey("a"));
        Assert.assertFalse((boolean)grandParent.containsKey("a"));
        Assert.assertEquals((Object)"aNew", (Object)child.get("a"));
        Assert.assertNull((Object)parent.get("a"));
        child.set("aNo", (Object)"a1");
        parent.set("bNo", (Object)"b2");
        grandParent.set("cNo", (Object)"c3");
        boolean exception = false;
        try {
            child.modify("bNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        exception = false;
        try {
            grandParent.modify("cNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        exception = false;
        try {
            child.modify("aNo", (Object)"new");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testRemoveValueComputationOnDispose() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild("ChildContext");
        parent.set("x", (Object)1);
        parent.set("y", (Object)1);
        parent.set("sum", (Object)new AddContextFunction());
        child.get("sum");
        Assert.assertEquals((long)1L, (long)this.listenersCount(child));
        child.dispose();
        Assert.assertEquals((long)0L, (long)this.listenersCount(parent));
    }

    @Test
    public void testNullInheritance() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild("ChildContext");
        parent.set("x", (Object)1);
        child.set("x", null);
        Assert.assertNull((Object)child.get("x"));
    }

    @Test
    public void testGetCFNotAValue() {
        IEclipseContext context = EclipseContextFactory.create((String)"ParentContext");
        context.set("x", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return IInjector.NOT_A_VALUE;
            }
        });
        Assert.assertNull((Object)context.get("x"));
        Assert.assertNull((Object)context.get("x"));
        Assert.assertNull((Object)context.get("x"));
        context.dispose();
    }

    @Test
    public void testGetCFNotAValueToParent() {
        IEclipseContext parent = EclipseContextFactory.create((String)"ParentContext");
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)1);
        child.set("x", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return IInjector.NOT_A_VALUE;
            }
        });
        Assert.assertEquals((Object)1, (Object)child.get("x"));
        parent.dispose();
    }

    @Test
    public void testContextFunctionOrdering() {
        IEclipseContext osgiContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        Assert.assertEquals((Object)"High", (Object)osgiContext.get("test.contextfunction.ranking"));
    }

    private int listenersCount(IEclipseContext context) {
        return ((EclipseContext)context).getListeners().size();
    }

    private static class ComputedValueBar
    extends ContextFunction {
        private ComputedValueBar() {
        }

        public Object compute(IEclipseContext context, String contextKey) {
            return context.get("bar");
        }
    }
}

