/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSuperClass;
import org.junit.Assert;
import org.junit.Test;

public class ReparentingTest {
    @Test
    public void testContextFunctionInParentRemove() {
        IEclipseContext parent = EclipseContextFactory.create((String)"parent");
        IEclipseContext child = parent.createChild("child");
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assert.assertEquals((long)6L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)child.get("sum")).intValue());
        child.setParent(EclipseContextFactory.create());
        Assert.assertEquals((long)6L, (long)((Integer)parent.get("sum")).intValue());
        Assert.assertNull((String)("Expected null but was: " + child.get("sum")), (Object)child.get("sum"));
    }

    @Test
    public void testContextFunctionInParentAdd() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        Assert.assertEquals(null, (Object)parent.get("sum"));
        Assert.assertEquals(null, (Object)child.get("sum"));
        IEclipseContext newParent = EclipseContextFactory.create();
        child.setParent(newParent);
        newParent.set("sum", (Object)new AddContextFunction());
        Assert.assertEquals((long)0L, (long)((Integer)newParent.get("sum")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)child.get("sum")).intValue());
        newParent.set("x", (Object)3);
        newParent.set("y", (Object)3);
        Assert.assertEquals((long)6L, (long)((Integer)newParent.get("sum")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)child.get("sum")).intValue());
    }

    @Test
    public void testContextFunctionNullBecomeParent() {
        IEclipseContext child = EclipseContextFactory.create();
        child.set("sum", (Object)new AddContextFunction());
        Assert.assertEquals((long)0L, (long)((Integer)child.get("sum")).intValue());
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.setParent(parent);
        Assert.assertEquals((long)6L, (long)((Integer)child.get("sum")).intValue());
    }

    @Test
    public void testContextFunctionParentBecomeNull() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("sum", (Object)new AddContextFunction());
        Assert.assertEquals((long)6L, (long)((Integer)child.get("sum")).intValue());
        child.setParent(null);
        Assert.assertEquals((long)0L, (long)((Integer)child.get("sum")).intValue());
    }

    @Test
    public void testContextFunctionSwitchParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("sum", (Object)new AddContextFunction());
        Assert.assertEquals((long)6L, (long)((Integer)child.get("sum")).intValue());
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)1);
        newParent.set("y", (Object)1);
        child.setParent(newParent);
        Assert.assertEquals((long)2L, (long)((Integer)child.get("sum")).intValue());
    }

    @Test
    public void testRunAndTrackNullBecomesParent() {
        final String[] value = new String[1];
        final IEclipseContext child = EclipseContextFactory.create();
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assert.assertEquals(null, (Object)value[0]);
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)"newParent");
        child.setParent(parent);
        Assert.assertEquals((Object)"newParent", (Object)value[0]);
    }

    @Test
    public void testRunAndTrackParentBecomeNull() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assert.assertEquals((Object)"oldParent", (Object)value[0]);
        child.setParent(null);
        Assert.assertNull((Object)value[0]);
    }

    @Test
    public void testRunAndTrackSwitchParent() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        Assert.assertEquals((Object)"oldParent", (Object)value[0]);
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)"newParent");
        child.setParent(newParent);
        Assert.assertEquals((Object)"newParent", (Object)value[0]);
    }

    @Test
    public void testInjectSwitchParent() {
        IEclipseContext oldParent = EclipseContextFactory.create();
        oldParent.set("String", (Object)"oldField");
        oldParent.set(String.class.getName(), (Object)"old");
        oldParent.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("String", (Object)"newField");
        newParent.set(String.class.getName(), (Object)"new");
        newParent.set(Float.class.getName(), (Object)new Float(34.5));
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        Assert.assertEquals((long)1L, (long)object.setStringCalled);
        Assert.assertEquals((Object)"old", (Object)object.getStringViaMethod());
        child.setParent(newParent);
        Assert.assertEquals((Object)"new", (Object)object.getStringViaMethod());
        Assert.assertEquals((long)2L, (long)object.setStringCalled);
    }

    @Test
    public void testInjectSwitchParentSameGrandparent() {
        IEclipseContext grandpa = EclipseContextFactory.create();
        grandpa.set("String", (Object)"field");
        grandpa.set(String.class.getName(), (Object)"s");
        grandpa.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext oldParent = grandpa.createChild();
        IEclipseContext newParent = grandpa.createChild();
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        Assert.assertEquals((long)1L, (long)object.setStringCalled);
        child.setParent(newParent);
        Assert.assertEquals((long)1L, (long)object.setStringCalled);
    }

    @Test
    public void testUpdateSameParent() {
        final Boolean[] called = new Boolean[1];
        IEclipseContext parent = EclipseContextFactory.create((String)"parent");
        IEclipseContext newParent = EclipseContextFactory.create((String)"newParent");
        IEclipseContext child = parent.createChild("child");
        parent.set("x", (Object)"1");
        newParent.set("x", (Object)"2");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                called[0] = true;
                context.get("x");
                return true;
            }
        });
        called[0] = false;
        child.setParent(parent);
        Assert.assertFalse((boolean)called[0]);
        child.setParent(newParent);
        Assert.assertTrue((boolean)called[0]);
    }

    @Test
    public void testUpdateSameParentCalculated() {
        final int[] testServiceCount = new int[]{0};
        IEclipseContext parentContext = EclipseContextFactory.create((String)"parent");
        parentContext.set(TestService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                testServiceCount[0] = testServiceCount[0] + 1;
                return ContextInjectionFactory.make(TestService.class, (IEclipseContext)context);
            }
        });
        IEclipseContext childContext = parentContext.createChild("child");
        childContext.get(TestService.class);
        Assert.assertEquals((long)1L, (long)testServiceCount[0]);
        childContext.setParent(childContext.getParent());
        Assert.assertEquals((long)1L, (long)testServiceCount[0]);
    }

    @Test
    public void testBug468048_contextFunction() {
        IEclipseContext p1 = EclipseContextFactory.create((String)"parent1");
        p1.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 1;
            }
        });
        IEclipseContext p2 = EclipseContextFactory.create((String)"parent2");
        p2.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 2;
            }
        });
        IEclipseContext intermed = p1.createChild("intermed");
        IEclipseContext leaf = intermed.createChild("leaf");
        Assert.assertEquals((Object)1, (Object)leaf.get("sample"));
        intermed.setParent(p2);
        Assert.assertEquals((Object)2, (Object)leaf.get("sample"));
    }

    @Test
    public void testBug468048_injection() {
        IEclipseContext p1 = EclipseContextFactory.create((String)"parent1");
        p1.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 1;
            }
        });
        IEclipseContext p2 = EclipseContextFactory.create((String)"parent2");
        p2.set("sample", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                return 2;
            }
        });
        IEclipseContext intermed = p1.createChild("intermed");
        IEclipseContext leaf = intermed.createChild("leaf");
        Bug468048 b = (Bug468048)ContextInjectionFactory.make(Bug468048.class, (IEclipseContext)leaf);
        Assert.assertEquals((Object)1, (Object)b.sample);
        intermed.setParent(p2);
        Assert.assertEquals((Object)2, (Object)b.sample);
    }

    public static class Bug468048 {
        @Inject
        @Named(value="sample")
        public Integer sample;
    }

    public static class TestService {
    }
}

