/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class ContextInjectionDisposeTest {
    @Test
    public void testContextDisposedNoArg() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"hello");
        class Injected {
            boolean disposeInvoked = false;
            @Inject
            private String Field;

            Injected() {
            }

            @PreDestroy
            public void dispose() {
                this.disposeInvoked = true;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        context.dispose();
        Assert.assertTrue((boolean)object.disposeInvoked);
    }

    @Test
    public void testDisposeContext() {
        IEclipseContext context = EclipseContextFactory.create();
        Object fieldValue = new Object();
        String methodValue = "abc";
        context.set(Object.class.getName(), fieldValue);
        context.set(String.class.getName(), (Object)methodValue);
        class Injected {
            boolean disposeInvoked = false;
            @Inject
            Object Field;
            String methodValue;

            Injected() {
            }

            @PreDestroy
            public void dispose() {
                this.disposeInvoked = true;
            }

            @Inject
            public void InjectedMethod(String arg) {
                this.methodValue = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assert.assertEquals((Object)fieldValue, (Object)object.Field);
        Assert.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.dispose();
        Assert.assertNotNull((Object)object.Field);
        Assert.assertNotNull((Object)object.methodValue);
        Assert.assertTrue((boolean)object.disposeInvoked);
    }

    @Test
    public void testReleaseObject() {
        IEclipseContext context = EclipseContextFactory.create();
        Integer fieldValue = 123;
        String methodValue = "abc";
        context.set(Integer.class.getName(), (Object)fieldValue);
        context.set(String.class.getName(), (Object)methodValue);
        class Injected {
            boolean disposeInvoked = false;
            @Inject
            Integer Field;
            Object methodValue;

            Injected() {
            }

            @PreDestroy
            public void dispose() {
                this.disposeInvoked = true;
            }

            @Inject
            public void InjectedMethod(@Optional String arg) {
                this.methodValue = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assert.assertEquals((Object)fieldValue, (Object)object.Field);
        Assert.assertEquals((Object)methodValue, (Object)object.methodValue);
        ContextInjectionFactory.uninject((Object)object, (IEclipseContext)context);
        Assert.assertEquals((Object)fieldValue, (Object)object.Field);
        Assert.assertNull((Object)object.methodValue);
        Assert.assertTrue((boolean)object.disposeInvoked);
    }
}

