/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class InjectStaticContextTest {
    @Test
    public void testStaticMake() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("a", (Object)"abc");
        parentContext.set("aConstructor", (Object)"abcConstructor");
        parentContext.set("b", (Object)"bbc");
        IEclipseContext localContext = EclipseContextFactory.create();
        localContext.set("b", (Object)"123");
        localContext.set("bConstructor", (Object)"123Constructor");
        localContext.set("c", (Object)"xyz");
        TestClass testObject = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)parentContext, (IEclipseContext)localContext);
        Assert.assertEquals((Object)parentContext, (Object)testObject.injectedContext);
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        localContext.set("b", (Object)"_123_");
        localContext.set("bConstructor", (Object)"_123Constructor_");
        localContext.set("c", (Object)"_xyz_");
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        localContext.dispose();
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        parentContext.set("a", (Object)"_abc_");
        parentContext.set("b", (Object)"_bbc_");
        Assert.assertEquals((Object)"_abc_", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)parentContext);
        Assert.assertNull((Object)testObject.injectedContext);
        Assert.assertNull((Object)testObject.aString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
        parentContext.set("a", (Object)"+abc+");
        Assert.assertNull((Object)testObject.aString);
        parentContext.dispose();
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
    }

    @Test
    public void testStaticInvoke() {
        IEclipseContext parentContext = EclipseContextFactory.create((String)"main");
        parentContext.set("a", (Object)"abc");
        IEclipseContext localContext = EclipseContextFactory.create((String)"local");
        localContext.set("b", (Object)"123");
        TestInvokeClass testObject = new TestInvokeClass();
        Assert.assertNull((Object)testObject.aString);
        Assert.assertNull((Object)testObject.bString);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)parentContext, (IEclipseContext)localContext, null);
        Assert.assertEquals((Object)"abc123", (Object)result);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)parentContext, (Object)testObject.context);
    }

    static class TestClass {
        public IEclipseContext injectedContext;
        public String aString;
        public String bString;
        public String cString;
        public String aConstructorString;
        public String bConstructorString;
        public int postConstructCalled = 0;
        public int preDestroyCalled = 0;

        TestClass() {
        }

        @Inject
        public void contextSet(@Optional IEclipseContext context) {
            this.injectedContext = context;
        }

        @Inject
        public void setA(@Optional @Named(value="a") String aString) {
            this.aString = aString;
        }

        @Inject
        public void setB(@Named(value="b") String bString) {
            this.bString = bString;
        }

        @Inject
        public void setC(@Named(value="c") String cString) {
            this.cString = cString;
        }

        @Inject
        public void InjectedMethod(@Named(value="aConstructor") String aString, @Named(value="bConstructor") String bString) {
            this.aConstructorString = aString;
            this.bConstructorString = bString;
        }

        @PostConstruct
        public void init() {
            ++this.postConstructCalled;
        }

        @PreDestroy
        public void dispose() {
            ++this.preDestroyCalled;
        }
    }

    static class TestInvokeClass {
        public String aString;
        public String bString;
        public IEclipseContext context;

        TestInvokeClass() {
        }

        @Execute
        public String testMethod(@Named(value="a") String aString, @Named(value="b") String bString, IEclipseContext context) {
            this.aString = aString;
            this.bString = bString;
            this.context = context;
            return String.valueOf(aString) + bString;
        }
    }
}

