/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.junit.Assert;
import org.junit.Test;

public class DisposeClassLinkTest {
    @Test
    public void testMake() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
    }

    @Test
    public void testDisposeParent() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
        parentContext.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
    }

    @Test
    public void testInject() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
    }

    @Test
    public void testDisposeParentFirst() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
        parentContext.dispose();
        Assert.assertEquals((long)1L, (long)test.getCount());
    }

    @Test
    public void testInjectedWithContext() throws Exception {
        IEclipseContext context = EclipseContextFactory.create();
        InjectionObject obj = (InjectionObject)ContextInjectionFactory.make(InjectionObject.class, (IEclipseContext)context);
        Assert.assertEquals((String)"The object has been injected with the context", (Object)context, (Object)obj.context);
        Assert.assertEquals((String)"@PostConstruct should have been called once", (long)1L, (long)obj.postConstruct);
        Assert.assertEquals((String)"@PreDestroy should not have been called", (long)0L, (long)obj.preDestroy);
        context.dispose();
        Assert.assertNotNull((Object)obj.context);
        Assert.assertEquals((String)"@PostConstruct should only have been called once", (long)1L, (long)obj.postConstruct);
        Assert.assertEquals((String)"@PreDestroy should have been called during uninjection", (long)1L, (long)obj.preDestroy);
    }

    @Test
    public void testBug430041() {
        IEclipseContext context = EclipseContextFactory.create();
        TestBug430041 obj = (TestBug430041)ContextInjectionFactory.make(TestBug430041.class, (IEclipseContext)context);
        context.dispose();
        Assert.assertEquals((long)1L, (long)obj.preDestroy);
    }

    public static class InjectionObject {
        @Inject
        IEclipseContext context;
        int postConstruct = 0;
        int preDestroy = 0;

        @PostConstruct
        void construct() {
            ++this.postConstruct;
        }

        @PreDestroy
        void destroy() {
            ++this.preDestroy;
        }
    }

    public static class MyTest {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }

    public static class TestBug430041 {
        int preDestroy = 0;

        @Inject
        @Optional
        public void inject(@EventTopic(value="Bla") String bla) {
        }

        @PreDestroy
        void destroy() {
            ++this.preDestroy;
        }
    }
}

