/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;
import org.eclipse.e4.core.internal.tests.di.extensions.InjectionEventTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class ExtendedSupplierInjectionTests {
    static final String TOPIC = "org/eclipse/e4/core/tests/di/extensions/ExtendedSupplierInjectionTests";
    static final String TOPIC_430041 = "org/eclipse/e4/core/tests/di/extensions/ExtendedSupplierInjectionTests430041";
    private InjectionEventTest.EventAdminHelper helper;

    @Before
    public void setUp() {
        InjectionEventTest.ensureEventAdminStarted();
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.helper = (InjectionEventTest.EventAdminHelper)ContextInjectionFactory.make(InjectionEventTest.EventAdminHelper.class, (IEclipseContext)localContext);
    }

    @Test
    public void testBug398728() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Object.class, new Object());
        Assert.assertEquals((long)0L, (long)EventTestObject.count);
        EventTestObject target = (EventTestObject)ContextInjectionFactory.make(EventTestObject.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)EventTestObject.count);
        this.helper.sendEvent(TOPIC, "event1data");
        Assert.assertEquals((long)1L, (long)EventTestObject.count);
        Assert.assertEquals((Object)"event1data", (Object)target.injectedObject);
    }

    @Test
    public void testBug430041() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Object.class, new Object());
        Assert.assertEquals((long)0L, (long)EventTestObject_430041.count);
        EventTestObject_430041 target = (EventTestObject_430041)ContextInjectionFactory.make(EventTestObject_430041.class, (IEclipseContext)context);
        context.set(EventTestObject_430041.class, (Object)target);
        Assert.assertEquals((long)0L, (long)EventTestObject_430041.count);
        this.helper.sendEvent(TOPIC_430041, "event1data");
        Assert.assertEquals((long)1L, (long)EventTestObject_430041.count);
        Assert.assertEquals((Object)"event1data", (Object)target.injectedObject);
        context.dispose();
        Assert.assertTrue((boolean)target.destroyed);
        this.helper.sendEvent(TOPIC_430041, "event1data_disposed");
        Assert.assertEquals((long)1L, (long)EventTestObject_430041.count);
        Assert.assertEquals((Object)"event1data", (Object)target.injectedObject);
    }

    @Test
    public void testSupplierOrdering() {
        BundleContext bc = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ExtendedObjectSupplier supplier = new ExtendedObjectSupplier(){

            public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
                return null;
            }
        };
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("dependency.injection.annotation", EventTopic.class.getName());
        ((Dictionary)properties).put("service.ranking", 100);
        ServiceRegistration sr = bc.registerService(ExtendedObjectSupplier.SERVICE_NAME, (Object)supplier, properties);
        try {
            Assert.assertEquals((Object)supplier, (Object)ProviderHelper.findProvider((String)EventTopic.class.getName(), null));
        }
        finally {
            sr.unregister();
        }
    }

    static class EventTestObject {
        static int count = 0;
        Object injectedObject;

        EventTestObject() {
        }

        @Inject
        @Optional
        void dontExecute(@EventTopic(value="org/eclipse/e4/core/tests/di/extensions/ExtendedSupplierInjectionTests") Object x) {
            ++count;
            this.injectedObject = x;
        }
    }

    static class EventTestObject_430041 {
        static int count = 0;
        Object injectedObject;
        private boolean destroyed;

        EventTestObject_430041() {
        }

        @Inject
        @Optional
        void dontExecute(@EventTopic(value="org/eclipse/e4/core/tests/di/extensions/ExtendedSupplierInjectionTests430041") Object x) {
            ++count;
            this.injectedObject = x;
        }

        @PreDestroy
        void goDown() {
            this.destroyed = true;
        }
    }
}

