/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.internal.extensions.util.EventUtils;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class InjectionEventTest {
    protected static boolean testFailed = false;
    private EventAdminHelper helper;

    @Before
    public void setUp() throws Exception {
        InjectionEventTest.ensureEventAdminStarted();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.helper = (EventAdminHelper)ContextInjectionFactory.make(EventAdminHelper.class, (IEclipseContext)localContext);
    }

    @Test
    public void testEventInjection() throws InvocationTargetException, InstantiationException {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)target.counter1);
        Assert.assertNull((Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "event1data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event2", "event2data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event3", "event3data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)2L, (long)target.counter3);
        Assert.assertEquals((Object)"event3data", (Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "abc");
        Assert.assertEquals((long)2L, (long)target.counter1);
        Assert.assertEquals((Object)"abc", (Object)target.string1);
        Assert.assertEquals((long)2L, (long)target.counter3);
        Assert.assertEquals((Object)"event3data", (Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
    }

    @Test
    public void testInjectType() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetEvent target = (InjectTargetEvent)ContextInjectionFactory.make(InjectTargetEvent.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)target.counter1);
        Assert.assertNull((Object)target.event);
        String eventTopic = "e4/test/eventInjection";
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", eventTopic);
        ((Dictionary)d).put("data1", 5);
        ((Dictionary)d).put("data2", "sample");
        Event event = new Event(eventTopic, d);
        this.helper.sendEvent(event);
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)event, (Object)target.event);
        Assert.assertEquals((Object)5, (Object)target.event.getProperty("data1"));
        Assert.assertEquals((Object)"sample", (Object)target.event.getProperty("data2"));
    }

    @Test
    public void testEventInjectionUnsubscribe() throws InvocationTargetException, InstantiationException {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        this.wrapSetup();
        System.gc();
        System.runFinalization();
        System.gc();
        this.helper.sendEvent("e4/test/event1", "wrong");
        Assert.assertFalse((boolean)testFailed);
    }

    @Test
    public void testInjectWildCard() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectStarEvent target = (InjectStarEvent)ContextInjectionFactory.make(InjectStarEvent.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)target.counter1);
        Assert.assertNull((Object)target.event);
        String eventTopic = "e4/test/eventInjection";
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", eventTopic);
        ((Dictionary)d).put("data1", 5);
        ((Dictionary)d).put("data2", "sample");
        Event event = new Event(eventTopic, d);
        this.helper.sendEvent(event);
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)event, (Object)target.event);
        Assert.assertEquals((Object)5, (Object)target.event.getProperty("data1"));
        Assert.assertEquals((Object)"sample", (Object)target.event.getProperty("data2"));
    }

    private void wrapSetup() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        this.helper.sendEvent("e4/test/event1", "event1data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        target.valid = false;
    }

    static void ensureEventAdminStarted() {
        if (CoreTestsActivator.getDefault().getEventAdmin() == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = CoreTestsActivator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public static class EventAdminHelper {
        @Inject
        public EventAdmin eventAdmin;

        public void sendEvent(String topic, Object data) {
            EventUtils.send((EventAdmin)this.eventAdmin, (String)topic, (Object)data);
        }

        public void sendEvent(Event event) {
            this.eventAdmin.sendEvent(event);
        }
    }

    static class InjectStarEvent {
        public int counter1 = 0;
        public Event event;

        InjectStarEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/*") Event event) {
            ++this.counter1;
            this.event = event;
        }
    }

    static class InjectTarget {
        public int counter1 = 0;
        public int counter3 = 0;
        public String string1;
        public String string3;
        public boolean valid = true;
        public MyBinding myBinding;

        InjectTarget() {
        }

        public void resetCounters() {
            this.counter3 = 0;
            this.counter1 = 0;
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/event1") String string1) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter1;
            this.string1 = string1;
        }

        @Inject
        public void receivedOptionalEvent(MyBinding myBinding, @Optional @EventTopic(value="e4/test/event3") String string3) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter3;
            this.myBinding = myBinding;
            this.string3 = string3;
        }
    }

    static class InjectTargetEvent {
        public int counter1 = 0;
        public Event event;

        InjectTargetEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/eventInjection") Event event) {
            ++this.counter1;
            this.event = event;
        }
    }

    @Singleton
    static class MyBinding {
        MyBinding() {
        }
    }
}

