/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.internal.tests.di.extensions.ComponentEnabler;
import org.eclipse.e4.core.internal.tests.di.extensions.DisabledServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.DisabledServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.FilterServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.FilterServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.SampleServiceA;
import org.eclipse.e4.core.internal.tests.di.extensions.SampleServiceB;
import org.eclipse.e4.core.internal.tests.di.extensions.TestService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceSupplierTestCase {
    private List<ServiceRegistration<?>> registrations = new ArrayList();

    @After
    public void cleanup() {
        this.registrations.forEach(r -> r.unregister());
    }

    @Test
    public void testInitialInject() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assert.assertNotNull((Object)bean.service);
        Assert.assertNotNull(bean.serviceList);
        Assert.assertSame(SampleServiceA.class, bean.service.getClass());
        Assert.assertEquals((long)1L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)4L, (long)bean.serviceList.size());
        Assert.assertEquals((long)1L, (long)bean.serviceListInjectionCount);
        Assert.assertSame(SampleServiceA.class, bean.serviceList.get(0).getClass());
        Assert.assertSame(SampleServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    public void testStaticFilter() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        TestStaticFilterBean bean = (TestStaticFilterBean)ContextInjectionFactory.make(TestStaticFilterBean.class, (IEclipseContext)serviceContext);
        Assert.assertNotNull((Object)bean.service);
        Assert.assertNotNull(bean.serviceList);
        Assert.assertSame(FilterServiceA.class, bean.service.getClass());
        Assert.assertEquals((long)1L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)2L, (long)bean.serviceList.size());
        Assert.assertEquals((long)1L, (long)bean.serviceListInjectionCount);
        Assert.assertSame(FilterServiceA.class, bean.serviceList.get(0).getClass());
        Assert.assertSame(FilterServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    public void testDynamicAdd() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assert.assertEquals((long)1L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)1L, (long)bean.serviceListInjectionCount);
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 100);
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        Assert.assertSame((Object)t, (Object)bean.service);
        Assert.assertEquals((long)2L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)2L, (long)bean.serviceListInjectionCount);
        Assert.assertEquals((long)5L, (long)bean.serviceList.size());
        Assert.assertSame((Object)t, (Object)bean.serviceList.get(0));
        TestService t2 = new TestService(){};
        properties = new Hashtable();
        properties.put("service.ranking", -1);
        this.registrations.add(context.registerService(TestService.class, (Object)t2, properties));
        Assert.assertSame((Object)t, (Object)bean.service);
        Assert.assertEquals((long)3L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)3L, (long)bean.serviceListInjectionCount);
        Assert.assertEquals((long)6L, (long)bean.serviceList.size());
        Assert.assertSame((Object)t, (Object)bean.serviceList.get(0));
    }

    @Test
    public void testDynamicAddRemove() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)serviceContext);
        Assert.assertEquals((long)1L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)1L, (long)bean.serviceListInjectionCount);
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 52);
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        Assert.assertSame((Object)t, (Object)bean.service);
        Assert.assertEquals((long)2L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)2L, (long)bean.serviceListInjectionCount);
        Assert.assertEquals((long)5L, (long)bean.serviceList.size());
        Assert.assertSame((Object)t, (Object)bean.serviceList.get(0));
        ServiceRegistration<?> registration = this.registrations.get(0);
        registration.unregister();
        this.registrations.remove(registration);
        Assert.assertEquals((long)3L, (long)bean.serviceInjectionCount);
        Assert.assertEquals((long)3L, (long)bean.serviceListInjectionCount);
        Assert.assertSame(SampleServiceA.class, bean.service.getClass());
        Assert.assertEquals((long)4L, (long)bean.serviceList.size());
        Assert.assertSame(SampleServiceA.class, bean.serviceList.get(0).getClass());
        Assert.assertSame(SampleServiceB.class, bean.serviceList.get(1).getClass());
    }

    @Test
    public void testCleanup() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext iec = EclipseContextFactory.getServiceContext((BundleContext)context).createChild();
        TestBean bean = (TestBean)ContextInjectionFactory.make(TestBean.class, (IEclipseContext)iec);
        iec.dispose();
        TestService t = new TestService(){};
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 2);
        this.registrations.add(context.registerService(TestService.class, (Object)t, properties));
        Assert.assertSame(SampleServiceA.class, bean.service.getClass());
    }

    @Test
    public void testOptionalReferences() throws InterruptedException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)context);
        TestDisabledBean bean = (TestDisabledBean)ContextInjectionFactory.make(TestDisabledBean.class, (IEclipseContext)serviceContext);
        Assert.assertNull((Object)bean.disabledService);
        Assert.assertEquals((long)0L, (long)bean.services.size());
        ServiceReference ref = context.getServiceReference(ComponentEnabler.class);
        ComponentEnabler enabler = (ComponentEnabler)context.getService(ref);
        try {
            enabler.enableDisabledServiceA();
            Thread.sleep(100L);
            Assert.assertNotNull((Object)bean.disabledService);
            Assert.assertEquals((long)1L, (long)bean.services.size());
            Assert.assertSame(DisabledServiceA.class, bean.disabledService.getClass());
            enabler.enableDisabledServiceB();
            Thread.sleep(100L);
            Assert.assertNotNull((Object)bean.disabledService);
            Assert.assertEquals((long)2L, (long)bean.services.size());
            Assert.assertSame(DisabledServiceB.class, bean.disabledService.getClass());
            enabler.disableDisabledServiceB();
            Thread.sleep(100L);
            Assert.assertNotNull((Object)bean.disabledService);
            Assert.assertEquals((long)1L, (long)bean.services.size());
            Assert.assertSame(DisabledServiceA.class, bean.disabledService.getClass());
            enabler.disableDisabledServiceA();
            Thread.sleep(100L);
            Assert.assertNull((Object)bean.disabledService);
            Assert.assertEquals((long)0L, (long)bean.services.size());
        }
        finally {
            enabler.disableDisabledServiceA();
            enabler.disableDisabledServiceB();
            Thread.sleep(100L);
        }
    }

    public static class TestBean {
        TestService service;
        List<TestService> serviceList;
        int serviceInjectionCount;
        int serviceListInjectionCount;

        @Inject
        public void setService(@Service TestService service) {
            this.service = service;
            ++this.serviceInjectionCount;
        }

        @Inject
        public void setServiceList(@Service List<TestService> serviceList) {
            this.serviceList = serviceList;
            ++this.serviceListInjectionCount;
        }
    }

    public static class TestDisabledBean {
        @Inject
        @Optional
        @Service(filterExpression="(component=disabled)")
        TestService disabledService;
        @Inject
        @Service(filterExpression="(component=disabled)")
        List<TestService> services;
    }

    public static class TestStaticFilterBean {
        TestService service;
        List<TestService> serviceList;
        int serviceInjectionCount;
        int serviceListInjectionCount;

        @Inject
        public void setService(@Service(filterExpression="(filtervalue=Test)") TestService service) {
            this.service = service;
            ++this.serviceInjectionCount;
        }

        @Inject
        public void setServiceList(@Service(filterExpression="(filtervalue=Test)") List<TestService> serviceList) {
            this.serviceList = serviceList;
            ++this.serviceListInjectionCount;
        }
    }
}

