/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.e4.core.internal.tests.nls.BundleMessagesRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class MessageRegistryTest {
    private IEclipseContext context;

    @Before
    public void setUp() {
        this.context = EclipseContextFactory.getServiceContext((BundleContext)CoreTestsActivator.getDefault().getBundleContext());
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
    }

    @Test
    public void testRegisterLocalizationByProperty() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.registerProperty(control, "localizableValue", "message");
        Assert.assertNotNull((Object)control.getLocalizableValue());
        Assert.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethod() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control, "setLocalizableValue", "message");
        Assert.assertNotNull((Object)control.getLocalizableValue());
        Assert.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByPropertyAndChangeLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.registerProperty(control, "localizableValue", "message");
        Assert.assertNotNull((Object)control.getLocalizableValue());
        Assert.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        Assert.assertEquals((Object)"BundleNachricht", (Object)control.getLocalizableValue());
    }

    @Test
    public void testRegisterLocalizationByMethodAndChangeLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestObject o = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)this.context);
        TestLocalizableObject control = new TestLocalizableObject();
        o.registry.register(control, "setLocalizableValue", "message");
        Assert.assertNotNull((Object)control.getLocalizableValue());
        Assert.assertEquals((Object)"BundleMessage", (Object)control.getLocalizableValue());
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        Assert.assertEquals((Object)"BundleNachricht", (Object)control.getLocalizableValue());
    }

    class TestLocalizableObject {
        private String localizableValue;

        TestLocalizableObject() {
        }

        public String getLocalizableValue() {
            return this.localizableValue;
        }

        public void setLocalizableValue(String localizableValue) {
            this.localizableValue = localizableValue;
        }
    }

    static class TestObject {
        @Inject
        BundleMessagesRegistry registry;

        TestObject() {
        }
    }
}

