/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.e4.core.internal.tests.nls.BundleMessages;
import org.eclipse.e4.core.internal.tests.nls.Messages;
import org.eclipse.e4.core.internal.tests.nls.ResourceBundleClassMessages;
import org.eclipse.e4.core.internal.tests.nls.ResourcesMessages;
import org.eclipse.e4.core.internal.tests.nls.SimpleMessages;
import org.eclipse.e4.core.services.nls.Translation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class NLSTest {
    private IEclipseContext context;
    private Locale beforeLocale;

    @Before
    public void setUp() {
        this.context = EclipseContextFactory.getServiceContext((BundleContext)CoreTestsActivator.getDefault().getBundleContext());
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
        this.beforeLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en"));
    }

    @After
    public void tearDown() {
        Locale.setDefault(this.beforeLocale);
    }

    @Test
    public void testSimpleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"SimpleMessage", (Object)messages.message);
        Assert.assertEquals((Object)"SimpleMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"SimpleMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"SimpleMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"SimpleNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"SimpleNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"SimpleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"SimpleMessage", (Object)messages.message);
        Assert.assertEquals((Object)"SimpleMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"SimpleMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"SimpleMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testSimpleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        SimpleMessages messages = o.simpleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"SimpleNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"SimpleNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"SimpleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"SimpleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"SimpleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"Message", (Object)messages.message);
        Assert.assertEquals((Object)"MessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"MessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"MessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"Nachricht", (Object)messages.message);
        Assert.assertEquals((Object)"NachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"NachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"NachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"Message", (Object)messages.message);
        Assert.assertEquals((Object)"MessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"MessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"MessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"MessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        Messages messages = o.Messages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"Nachricht", (Object)messages.message);
        Assert.assertEquals((Object)"NachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"NachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"NachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"MessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"NachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"BundleMessage", (Object)messages.message);
        Assert.assertEquals((Object)"BundleMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"BundleMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"BundleMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"BundleNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"BundleNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"BundleNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"BundleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"BundleMessage", (Object)messages.message);
        Assert.assertEquals((Object)"BundleMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"BundleMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"BundleMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"BundleMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testBundleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        BundleMessages messages = o.bundleMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"BundleNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"BundleNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"BundleNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"BundleNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"BundleMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"BundleNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessage", (Object)messages.message);
        Assert.assertEquals((Object)"ResourceBundleClassMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourceBundleClassMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourceBundleNachrichtMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessage", (Object)messages.message);
        Assert.assertEquals((Object)"ResourceBundleClassMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourceBundleClassMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testClassBasedResourceBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        ResourceBundleClassMessages messages = o.bundleClassMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourceBundleNachrichtMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourceBundleClassCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourceBundleClassNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourcesMessage", (Object)messages.message);
        Assert.assertEquals((Object)"ResourcesMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourcesMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourcesMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.GERMAN);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourcesNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"ResourcesNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourcesNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.ENGLISH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourcesMessage", (Object)messages.message);
        Assert.assertEquals((Object)"ResourcesMessageUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourcesMessageCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourcesMessageUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"The idea is from Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    @Test
    public void testResourcesBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)Locale.FRENCH);
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        ResourcesMessages messages = o.resourcesMessages;
        Assert.assertNotNull((Object)messages);
        Assert.assertNotNull((Object)messages.message);
        Assert.assertNotNull((Object)messages.message_one);
        Assert.assertNotNull((Object)messages.messageOne);
        Assert.assertNotNull((Object)messages.message_two);
        Assert.assertNotNull((Object)messages.messageThree);
        Assert.assertNotNull((Object)messages.messageFour);
        Assert.assertNotNull((Object)messages.messageFive_Sub);
        Assert.assertNotNull((Object)messages.messageSix_Sub);
        Assert.assertNotNull((Object)messages.messageSeven_Sub);
        Assert.assertNotNull((Object)messages.messageEight_Sub);
        Assert.assertNotNull((Object)messages.messageNine_Sub);
        Assert.assertEquals((Object)"ResourcesNachricht", (Object)messages.message);
        Assert.assertEquals((Object)"ResourcesNachrichtUnderscore", (Object)messages.message_one);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCase", (Object)messages.messageOne);
        Assert.assertEquals((Object)"ResourcesNachrichtUnderscoreDot", (Object)messages.message_two);
        Assert.assertEquals((Object)"ResourcesMessageCamelCaseDot", (Object)messages.messageThree);
        Assert.assertEquals((Object)"Die Idee ist von Tom", (Object)messages.messageFour);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreOriginal", (Object)messages.messageFive_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasified", (Object)messages.messageSix_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeCamelCasifiedAndDeUnderscorified", (Object)messages.messageSeven_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorified", (Object)messages.messageEight_Sub);
        Assert.assertEquals((Object)"ResourcesNachrichtCamelCaseAndUnderscoreDeUnderscorifiedAndDeCamelCasified", (Object)messages.messageNine_Sub);
    }

    static class TestBundleObject {
        @Inject
        @Translation
        BundleMessages bundleMessages;

        TestBundleObject() {
        }
    }

    static class TestMessagesObject {
        @Inject
        @Translation
        Messages Messages;

        TestMessagesObject() {
        }
    }

    static class TestResourceBundleClassObject {
        @Inject
        @Translation
        ResourceBundleClassMessages bundleClassMessages;

        TestResourceBundleClassObject() {
        }
    }

    static class TestResourcesBundleObject {
        @Inject
        @Translation
        ResourcesMessages resourcesMessages;

        TestResourcesBundleObject() {
        }
    }

    static class TestSimpleObject {
        @Inject
        @Translation
        SimpleMessages simpleMessages;

        TestSimpleObject() {
        }
    }
}

