/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core;

import java.util.Date;
import org.eclipse.e4.ui.css.core.impl.engine.CSSEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class CSSEngineTest {
    @Test
    public void testSelectorMatch() throws Exception {
        TestCSSEngine engine = new TestCSSEngine();
        SelectorList list = engine.parseSelectors("Date");
        engine.setElementProvider((element, engine1) -> new TestElement(element.getClass().getSimpleName(), engine1));
        Assert.assertFalse((boolean)engine.matches(list.item(0), new Object(), null));
        Assert.assertTrue((boolean)engine.matches(list.item(0), new Date(), null));
    }

    @Test
    public void testSelectorMatchOneOf() throws Exception {
        TestCSSEngine engine = this.engineWhichProducesElementsWithAttributeA();
        Selector selector = engine.parseSelectors("E[a~='B']").item(0);
        Assert.assertTrue((boolean)engine.matches(selector, "B AB", null));
        Assert.assertTrue((boolean)engine.matches(selector, "BC B", null));
        Assert.assertFalse((boolean)engine.matches(selector, "ABC", null));
        Assert.assertTrue((boolean)engine.matches(selector, "B", null));
    }

    @Test
    public void testSelectorAttributeIs() throws Exception {
        TestCSSEngine engine = this.engineWhichProducesElementsWithAttributeA();
        Selector selector = engine.parseSelectors("E[a='B']").item(0);
        Assert.assertFalse((boolean)engine.matches(selector, "ABC", null));
        Assert.assertTrue((boolean)engine.matches(selector, "B", null));
    }

    @Test
    public void testSelectorAttributeIs_EmptySting() throws Exception {
        TestCSSEngine engine = this.engineWhichProducesElementsWithAttributeA();
        Selector selector = engine.parseSelectors("E[a='']").item(0);
        Assert.assertFalse((boolean)engine.matches(selector, "ABC", null));
        Assert.assertTrue((boolean)engine.matches(selector, "", null));
    }

    @Test
    public void testSelectorAttributeIs_NotPresent() throws Exception {
        TestCSSEngine engine = this.engineWhichProducesElementsWithAttributeA();
        Selector selector = engine.parseSelectors("E[b='']").item(0);
        Assert.assertFalse((boolean)engine.matches(selector, "ABC", null));
        Assert.assertFalse((boolean)engine.matches(selector, "", null));
    }

    private TestCSSEngine engineWhichProducesElementsWithAttributeA() {
        TestCSSEngine engine = new TestCSSEngine();
        engine.setElementProvider((element, aEngine) -> {
            TestElement e = new TestElement("E", aEngine);
            e.setAttribute("a", element.toString());
            return e;
        });
        return engine;
    }

    private static class TestCSSEngine
    extends CSSEngineImpl {
        private TestCSSEngine() {
        }

        public void reapply() {
        }
    }
}

