/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.engine.CSSEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.stylesheets.StyleSheet;

public class InheritTest
extends TestCase {
    public void testInheritFromParent() throws Exception {
        String css = "Canvas { property: myValue; }\nButton { property: inherit; }\n";
        CSSEngine engine = this.createEngine(css);
        TestElement canvas = new TestElement("Canvas", engine);
        TestElement button = new TestElement("Button", canvas, engine);
        engine.applyStyles((Object)canvas, true);
        InheritTest.assertEquals((String)"myValue", (String)button.getAttribute("property"));
    }

    public void testInheritAsDefault() throws Exception {
        String css = "* { property: inherit; }\nCanvas { property: myValue; }\n";
        CSSEngine engine = this.createEngine(css);
        TestElement canvas = new TestElement("Canvas", engine);
        TestElement button = new TestElement("Button", canvas, engine);
        engine.applyStyles((Object)canvas, true);
        InheritTest.assertEquals((String)"myValue", (String)button.getAttribute("property"));
    }

    public void testInheritExplicitProperty() throws Exception {
        String css = "Button { property: inherit; }\n";
        CSSEngine engine = this.createEngine(css);
        TestElement canvas = new TestElement("Canvas", engine);
        canvas.setAttribute("property", "myValue");
        TestElement button = new TestElement("Button", canvas, engine);
        engine.applyStyles((Object)canvas, true);
        InheritTest.assertEquals((String)"myValue", (String)button.getAttribute("property"));
    }

    private CSSEngine createEngine(String css) throws IOException {
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        CSSEngineImpl engine = new CSSEngineImpl((ExtendedDocumentCSS)docCss){
            {
                this.registerCSSPropertyHandlerProvider(new TestHandlerProvider());
            }

            public void reapply() {
            }

            public Element getElement(Object element) {
                if (element instanceof TestElement) {
                    return (TestElement)((Object)element);
                }
                return super.getElement(element);
            }
        };
        return engine;
    }

    private static class PropertyToAttributeMapper
    implements ICSSPropertyHandler {
        private PropertyToAttributeMapper() {
        }

        public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
            if ("property".equals(property)) {
                TestElement testElement = (TestElement)((Object)element);
                testElement.setAttribute("property", value.getCssText());
                return true;
            }
            return false;
        }

        public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
            if ("property".equals(property)) {
                TestElement testElement = (TestElement)((Object)element);
                return testElement.getAttribute("property");
            }
            return null;
        }
    }

    private static class TestHandlerProvider
    implements ICSSPropertyHandlerProvider {
        private PropertyToAttributeMapper propertyToAttributeMapper = new PropertyToAttributeMapper();

        private TestHandlerProvider() {
        }

        public CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine engine, Object element, CSSStyleDeclaration newStyle, String pseudoE) throws Exception {
            return null;
        }

        public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(Object element, String property) throws Exception {
            return Collections.singleton(this.propertyToAttributeMapper);
        }

        public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(String property) throws Exception {
            return Collections.singleton(this.propertyToAttributeMapper);
        }

        public Collection<String> getCSSProperties(Object element) {
            return Collections.singleton("property");
        }
    }
}

