/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SelectorList;

public class SelectorTest {
    private CSSEngine engine;

    @Before
    public void setUp() throws Exception {
        this.engine = ParserTestUtil.createEngine();
    }

    @Test
    public void testSimpleSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Assert.assertEquals((Object)"Type1", (Object)list.item(0).toString());
    }

    @Test
    public void testMultipleSelectors() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1, Type2");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.getLength());
        Assert.assertEquals((Object)"Type1", (Object)list.item(0).toString());
        Assert.assertEquals((Object)"Type2", (Object)list.item(1).toString());
    }

    @Test
    public void testClassSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors(".Class1");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Assert.assertEquals((Object)"*[class=\"Class1\"]", (Object)list.item(0).toString());
    }

    @Test
    public void testAttributeSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("*[class='Class1']");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Assert.assertEquals((Object)"*[class=\"Class1\"]", (Object)list.item(0).toString());
    }

    @Test
    public void testErrorAttributeSelector() throws IOException {
        try {
            this.engine.parseSelectors("*[class='Class1'");
            Assert.fail((String)"Parser should have errored on missing bracket");
        }
        catch (CSSParseException cSSParseException) {}
    }
}

