/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ValueTest {
    private CSSEngine engine;

    @Before
    public void setUp() {
        this.engine = ParserTestUtil.createEngine();
    }

    @Test
    public void testFloat() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("2.0");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((Object)"2.0", (Object)value.getCssText());
    }

    @Test
    public void testInt() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)1L);
        Assert.assertEquals((Object)"34", (Object)value.getCssText());
    }

    @Test
    public void testIdentifier() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("SomeWord");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)21L);
        Assert.assertEquals((Object)"SomeWord", (Object)value.getCssText());
    }

    @Test
    public void testPercent() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("30%");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)2L);
        Assert.assertEquals((Object)"30.0%", (Object)value.getCssText());
    }

    @Test
    public void testPixel() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("26px");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)5L);
        Assert.assertEquals((Object)"26.0px", (Object)value.getCssText());
    }

    @Test
    public void testInch() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("88in");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)8L);
        Assert.assertEquals((Object)"88.0in", (Object)value.getCssText());
    }

    @Test
    public void testEm() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("75em");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)3L);
        Assert.assertEquals((Object)"75.0em", (Object)value.getCssText());
    }

    @Test
    public void testURI() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("url(./somepath/picture.gif)");
        Assert.assertTrue((boolean)(value instanceof Measure));
        Assert.assertEquals((long)((Measure)value).getPrimitiveType(), (long)20L);
        Assert.assertEquals((Object)"url(./somepath/picture.gif)", (Object)value.getCssText());
    }

    @Test
    public void testList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34 34 34");
        Assert.assertTrue((boolean)(value instanceof CSSValueList));
        Assert.assertEquals((long)((CSSValueList)value).getCssValueType(), (long)2L);
        Assert.assertEquals((long)3L, (long)((CSSValueList)value).getLength());
        Assert.assertTrue((boolean)(((CSSValueList)value).item(0) instanceof Measure));
        Assert.assertEquals((long)1L, (long)((Measure)((CSSValueList)value).item(0)).getPrimitiveType());
        Assert.assertTrue((boolean)(((CSSValueList)value).item(1) instanceof Measure));
        Assert.assertEquals((long)1L, (long)((Measure)((CSSValueList)value).item(1)).getPrimitiveType());
        Assert.assertTrue((boolean)(((CSSValueList)value).item(2) instanceof Measure));
        Assert.assertEquals((long)1L, (long)((Measure)((CSSValueList)value).item(2)).getPrimitiveType());
        Assert.assertEquals((Object)"34 34 34", (Object)value.getCssText());
    }

    @Test
    public void testCommaSeparatedList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34, 34, 34");
        Assert.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList list = (CSSValueList)value;
        Assert.assertEquals((long)list.getCssValueType(), (long)2L);
        Assert.assertEquals((long)5L, (long)list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            Assert.assertTrue((boolean)(list.item(i) instanceof Measure));
            ++i;
        }
        Assert.assertEquals((long)1L, (long)((Measure)list.item(0)).getPrimitiveType());
        Assert.assertEquals((long)3L, (long)((Measure)list.item(1)).getPrimitiveType());
        Assert.assertEquals((long)1L, (long)((Measure)list.item(2)).getPrimitiveType());
        Assert.assertEquals((long)3L, (long)((Measure)list.item(3)).getPrimitiveType());
        Assert.assertEquals((long)1L, (long)((Measure)list.item(4)).getPrimitiveType());
        Assert.assertTrue((boolean)value.getCssText().matches("34\\s*,\\s*34\\s*,\\s*34"));
    }
}

