/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.preference;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.preference.EclipsePreferencesElement;
import org.eclipse.e4.ui.css.swt.properties.preference.EclipsePreferencesHandler;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class EclipsePreferencesHandlerTest {
    @Test
    public void testApplyCSSProperty() {
        CSSEngine engine = (CSSEngine)Mockito.mock(CSSEngine.class);
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesElement element = new EclipsePreferencesElement((IEclipsePreferences)preferences, engine);
        CSSValue value = (CSSValue)Mockito.mock(CSSValue.class);
        ((CSSValue)Mockito.doReturn((Object)1).when((Object)value)).getCssValueType();
        EclipsePreferencesHandlerTestable handler = (EclipsePreferencesHandlerTestable)((Object)Mockito.spy((Object)((Object)new EclipsePreferencesHandlerTestable())));
        try {
            handler.applyCSSProperty(element, "preferences", value, null, engine);
        }
        catch (Exception exception) {
            Assert.fail((String)"Apply CSSProperty should not throw exception");
        }
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).overrideProperty((IEclipsePreferences)preferences, value);
        engine.dispose();
    }

    @Test
    public void testApplyCSSPropertyWhenCssValueList() {
        CSSEngine engine = (CSSEngine)Mockito.mock(CSSEngine.class);
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesElement element = new EclipsePreferencesElement((IEclipsePreferences)preferences, engine);
        CSSValue[] values = new CSSValue[]{(CSSValue)Mockito.mock(CSSValue.class), (CSSValue)Mockito.mock(CSSValue.class)};
        CSSValueList listValue = (CSSValueList)Mockito.mock(CSSValueList.class);
        ((CSSValueList)Mockito.doReturn((Object)2).when((Object)listValue)).getCssValueType();
        ((CSSValueList)Mockito.doReturn((Object)values.length).when((Object)listValue)).getLength();
        ((CSSValueList)Mockito.doReturn((Object)values[0]).when((Object)listValue)).item(0);
        ((CSSValueList)Mockito.doReturn((Object)values[1]).when((Object)listValue)).item(1);
        EclipsePreferencesHandlerTestable handler = (EclipsePreferencesHandlerTestable)((Object)Mockito.spy((Object)((Object)new EclipsePreferencesHandlerTestable())));
        try {
            handler.applyCSSProperty(element, "preferences", listValue, null, engine);
        }
        catch (Exception exception) {
            Assert.fail((String)"Apply CSSProperty should not throw exception");
        }
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)2)))).overrideProperty((IEclipsePreferences)Matchers.any(IEclipsePreferences.class), (CSSValue)Matchers.any(CSSValue.class));
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).overrideProperty((IEclipsePreferences)preferences, values[0]);
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).overrideProperty((IEclipsePreferences)preferences, values[1]);
        engine.dispose();
    }

    @Test
    public void testOverridePropertyWithCSSValue() {
        EclipsePreferences preferences = new EclipsePreferences();
        CSSValue value1 = (CSSValue)Mockito.mock(CSSValue.class);
        ((CSSValue)Mockito.doReturn((Object)"name1=value1").when((Object)value1)).getCssText();
        CSSValue value2 = (CSSValue)Mockito.mock(CSSValue.class);
        ((CSSValue)Mockito.doReturn((Object)" name2  = value2").when((Object)value2)).getCssText();
        EclipsePreferencesHandlerTestable handler = (EclipsePreferencesHandlerTestable)((Object)Mockito.spy((Object)((Object)new EclipsePreferencesHandlerTestable())));
        handler.overridePropertyUnMocked((IEclipsePreferences)preferences, value1);
        handler.overridePropertyUnMocked((IEclipsePreferences)preferences, value2);
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).overrideProperty((IEclipsePreferences)preferences, "name1", "value1");
        ((EclipsePreferencesHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).overrideProperty((IEclipsePreferences)preferences, "name2", "value2");
    }

    @Test
    public void testOverridePropertyWithNameAndValueSplit() {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHandlerTestable handler = new EclipsePreferencesHandlerTestable();
        handler.overridePropertyUnMocked((IEclipsePreferences)preferences, "name", "value");
        Assert.assertEquals((Object)"value", (Object)preferences.get("name", null));
        Assert.assertTrue((boolean)preferences.get("overriddenByCSS", "").contains("name"));
    }

    @Test
    @Ignore(value="Failing on Hudson, see Bug 501875")
    public void testOverridePropertyWithNameAndValueSplitAndNameAlreadyAddedByUser() {
        EclipsePreferences preferences = new EclipsePreferences();
        preferences.put("name", "valueSetByUser");
        EclipsePreferencesHandlerTestable handler = new EclipsePreferencesHandlerTestable();
        handler.overridePropertyUnMocked((IEclipsePreferences)preferences, "name", "value");
        Assert.assertEquals((Object)"valueSetByUser", (Object)preferences.get("name", null));
        Assert.assertNull((Object)preferences.get("overriddenByCSS", null));
    }

    @Test
    public void testCustomizePreferenceOverriddenByCSS() {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHandlerTestable handler = new EclipsePreferencesHandlerTestable();
        handler.overridePropertyUnMocked((IEclipsePreferences)preferences, "name", "value");
        Assert.assertEquals((Object)"value", (Object)preferences.get("name", null));
        Assert.assertTrue((boolean)preferences.get("overriddenByCSS", "").contains("name"));
        preferences.put("name", "customizedValue");
        Assert.assertEquals((Object)"customizedValue", (Object)preferences.get("name", null));
        Assert.assertFalse((boolean)preferences.get("overriddenByCSS", "").contains("name"));
    }

    public static class EclipsePreferencesHandlerTestable
    extends EclipsePreferencesHandler {
        public void overrideProperty(IEclipsePreferences preferences, CSSValue value) {
        }

        public void overridePropertyUnMocked(IEclipsePreferences preferences, CSSValue value) {
            super.overrideProperty(preferences, value);
        }

        public void overrideProperty(IEclipsePreferences preferences, String name, String value) {
        }

        public void overridePropertyUnMocked(IEclipsePreferences preferences, String name, String value) {
            super.overrideProperty(preferences, name, value);
        }
    }
}

