/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.swt.dom.CTabFolderElement;
import org.eclipse.e4.ui.css.swt.properties.custom.CSSPropertyMruVisibleSWTHandler;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CTabFolderTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);

    protected CTabFolder createTestCTabFolder(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return folderToTest;
    }

    protected ToolBar[] createTestToolBars(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderA = new CTabFolder(panel, 0);
        CTabItem tabA = new CTabItem(folderA, 0);
        tabA.setText("FolderA TAB ITEM");
        ToolBar toolbarA = new ToolBar((Composite)folderA, 0x800100);
        folderA.setTopRight((Control)toolbarA);
        CTabFolder folderB = new CTabFolder(panel, 0);
        CTabItem tabB = new CTabItem(folderB, 0);
        tabB.setText("FolderB TAB ITEM");
        ToolBar toolbarB = new ToolBar((Composite)folderB, 0x800100);
        folderB.setTopRight((Control)toolbarB);
        ToolBar toolbarC = new ToolBar(panel, 0x800100);
        this.engine.applyStyles((Object)shell, true);
        return new ToolBar[]{toolbarA, toolbarB, toolbarC};
    }

    protected Shell createShell(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 0);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    @Test
    public void testBackgroundColor() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { background-color: #0000FF }");
        Assert.assertEquals((Object)BLUE, (Object)folderToTest.getBackground().getRGB());
    }

    @Test
    public void testTextColor() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { color: #0000FF }");
        Assert.assertEquals((Object)BLUE, (Object)folderToTest.getForeground().getRGB());
    }

    @Test
    public void testFontRegular() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Verdana 16px }");
        Assert.assertEquals((long)1L, (long)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)16L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
    }

    @Test
    public void testFontBold() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-weight: bold }");
        Assert.assertEquals((long)1L, (long)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    @Test
    public void testFontItalic() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-style: italic }");
        Assert.assertEquals((long)1L, (long)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Ignore(value="this test was commented before bug 443094")
    @Test
    public void testBorderVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getBorderVisible());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getBorderVisible());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
    }

    @Test
    public void testSimple() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { simple: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getSimple());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { simple: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getSimple());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
    }

    @Test
    public void testMaximizeVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { maximize-visible: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getMaximizeVisible());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { maximize-visible: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getMaximizeVisible());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
    }

    @Test
    public void testMinimizeVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { minimize-visible: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getMinimizeVisible());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { minimize-visible: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getMinimizeVisible());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
    }

    @Test
    public void testMRUVisible() {
        boolean mruControlledByCSSDefault = CSSPropertyMruVisibleSWTHandler.isMRUControlledByCSS();
        try {
            CSSPropertyMruVisibleSWTHandler.setMRUControlledByCSS((boolean)true);
            CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: true}");
            Assert.assertEquals((Object)true, (Object)folderToTest.getMRUVisible());
            Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
            folderToTest.getShell().close();
            folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: false}");
            Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
            Assert.assertEquals((Object)false, (Object)folderToTest.getMRUVisible());
        }
        finally {
            CSSPropertyMruVisibleSWTHandler.setMRUControlledByCSS((boolean)mruControlledByCSSDefault);
        }
    }

    @Test
    public void testMRUVisibleCSSControlOff() {
        boolean mruControlledByCSSDefault = CSSPropertyMruVisibleSWTHandler.isMRUControlledByCSS();
        try {
            CSSPropertyMruVisibleSWTHandler.setMRUControlledByCSS((boolean)false);
            CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: true}");
            Assert.assertEquals((Object)false, (Object)folderToTest.getMRUVisible());
            Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
            folderToTest.getShell().close();
            folderToTest = this.createTestCTabFolder("CTabFolder { mru-visible: false}");
            Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
            Assert.assertEquals((Object)false, (Object)folderToTest.getMRUVisible());
        }
        finally {
            CSSPropertyMruVisibleSWTHandler.setMRUControlledByCSS((boolean)mruControlledByCSSDefault);
        }
    }

    @Test
    public void testMaximized() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { maximized: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getMaximized());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { maximized: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getMaximized());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
    }

    @Test
    public void testMinimized() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { minimized: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getMinimized());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { minimized: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getMinimized());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
    }

    @Test
    public void testTabHeight() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 30px }");
        Assert.assertEquals((long)30L, (long)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40px }");
        Assert.assertEquals((long)40L, (long)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40px 50px }");
        Assert.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
        Assert.assertNotSame((Object)50, (Object)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { tab-height: 40 }");
        Assert.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
    }

    @Test
    public void testSingle() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { single: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getSingle());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "single", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { single: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getSingle());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "single", null));
    }

    @Test
    public void testUnselectedCloseVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { unselected-close-visible: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getUnselectedCloseVisible());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { unselected-close-visible: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getUnselectedCloseVisible());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
    }

    @Test
    public void testUnselectedImageVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { unselected-image-visible: true}");
        Assert.assertEquals((Object)true, (Object)folderToTest.getUnselectedImageVisible());
        Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { unselected-image-visible: false}");
        Assert.assertEquals((Object)false, (Object)folderToTest.getUnselectedImageVisible());
        Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
    }

    @Test
    public void testRetrievePropertyNull() {
        Shell shell = this.createShell("Shell {color:red}");
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "border-visible", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "maximized", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "maximize-visible", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "minimize-visible", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "mru-visible", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "show-close", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "simple", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "single", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "unselected-close-visible", null));
        Assert.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "unselected-image-visible", null));
    }

    @Test
    public void testTopRightAsDescendentChild() {
        ToolBar[] toolBars = this.createTestToolBars("CTabFolder.special ToolBar { background: #FF0000}\nCTabFolder ToolBar { background: #00FF00}\nCTabFolder.extraordinary ToolBar { background: #FFFFFF}\nToolBar { background: #0000FF}");
        ToolBar barA = toolBars[0];
        ToolBar barB = toolBars[1];
        ToolBar barC = toolBars[2];
        CTabFolderElement.setCSSClass((Widget)barA.getParent(), (String)"special");
        this.engine.applyStyles((Object)barA.getShell(), true);
        Assert.assertEquals((Object)RED, (Object)barA.getBackground().getRGB());
        Assert.assertEquals((Object)GREEN, (Object)barB.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)barC.getBackground().getRGB());
        CTabFolderElement.setCSSClass((Widget)barA.getParent(), (String)"extraordinary");
        this.engine.applyStyles((Object)barA.getShell(), true);
        Assert.assertEquals((Object)WHITE, (Object)barA.getBackground().getRGB());
    }
}

