/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FontDefinitionTest
extends CSSSWTTestCase {
    @Test
    public void testFontDefinition() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;font-weight: bold;}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        Assert.assertNull((Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assert.assertNotNull((Object)definition.getValue());
        Assert.assertEquals((Object)"Times", (Object)definition.getValue()[0].getName());
        Assert.assertEquals((long)12L, (long)definition.getValue()[0].getHeight());
        Assert.assertEquals((long)3L, (long)definition.getValue()[0].getStyle());
        Assert.assertEquals((Object)"categoryId", (Object)definition.getCategoryId());
        Assert.assertEquals((Object)"name", (Object)definition.getName());
        Assert.assertTrue((boolean)definition.getDescription().startsWith("description"));
        Assert.assertTrue((boolean)definition.isOverridden());
    }

    @Test
    public void testFontDefinitionWhenNameCategoryIdAndDescriptionOverridden() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic; font-weight: bold; label:'nameOverridden'; category: '#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        Assert.assertNull((Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assert.assertNotNull((Object)definition.getValue());
        Assert.assertEquals((Object)"Times", (Object)definition.getValue()[0].getName());
        Assert.assertEquals((long)12L, (long)definition.getValue()[0].getHeight());
        Assert.assertEquals((long)3L, (long)definition.getValue()[0].getStyle());
        Assert.assertEquals((Object)"categoryIdOverridden", (Object)definition.getCategoryId());
        Assert.assertEquals((Object)"nameOverridden", (Object)definition.getName());
        Assert.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        Assert.assertTrue((boolean)definition.isOverridden());
    }

    @Test
    public void testFontDefinitionWhenDefinitionStylesheetNotFound() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;}", this.display);
        FontDefinition definition = this.fontDefinition("font definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        Assert.assertNull((Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assert.assertNull((Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
    }

    @Test
    public void testWidgetWithFontDefinitionAsFontFamily() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", new FontData("Times", 12, 2));
        this.engine = this.createEngine("Label {font-family: '#org-eclipse-jface-bannerfont'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        Font font = new Font((Device)this.display, "Arial", 9, 1);
        label.setFont(font);
        label.setText("Some label text");
        this.engine.applyStyles((Object)label, true);
        Assert.assertEquals((Object)"Times", (Object)label.getFont().getFontData()[0].getName());
        Assert.assertEquals((long)12L, (long)label.getFont().getFontData()[0].getHeight());
        Assert.assertEquals((long)3L, (long)label.getFont().getFontData()[0].getStyle());
        shell.dispose();
        font.dispose();
    }

    private FontDefinition fontDefinition(String uniqueId, String name, String categoryId, String description) {
        return new FontDefinition(new FontDefinition(name, uniqueId, "defaultsId", "value", categoryId, true, description), new FontData[]{new FontData("Arial", 10, 0)});
    }

    private void registerFontProviderWith(final String symbolicName, final FontData fontData) {
        try {
            new CSSActivator(){

                public IColorAndFontProvider getColorAndFontProvider() {
                    IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
                    ((IColorAndFontProvider)Mockito.doReturn((Object)new FontData[]{fontData}).when((Object)provider)).getFont(symbolicName);
                    return provider;
                }
            }.start(null);
        }
        catch (Exception exception) {
            Assert.fail((String)"CssActivator start failed");
        }
    }
}

