/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InheritTest
extends CSSSWTTestCase {
    private Color redColor;
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB RED = new RGB(255, 0, 0);

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.redColor = new Color((Device)this.display, RED);
    }

    @Override
    @After
    public void tearDown() {
        this.redColor.dispose();
        super.tearDown();
    }

    @Test
    public void testBackgroundNoInherit() {
        Label labelToTest = this.createTestLabel("Label { background-color: #00FF00; }\nComposite Label { color: #0000FF; }", true);
        Assert.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
        Assert.assertEquals((Object)GREEN, (Object)labelToTest.getBackground().getRGB());
    }

    @Test
    public void testBackgroundInherit() throws Exception {
        Label labelToTest = this.createTestLabel("Label { background-color: #00FF00; }\nComposite { background-color: #FF0000; } \nComposite Label { background-color: inherit; color: #0000FF; }", false);
        Assert.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
        Assert.assertEquals((Object)RED, (Object)labelToTest.getBackground().getRGB());
    }

    @Test
    public void testBackgroundInheritsAlsoExplicitlySetColors() throws Exception {
        Label labelToTest = this.createTestLabel("Label { background-color: #00FF00; }\nComposite Label { background-color: inherit; color: #0000FF; }", true);
        Assert.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
        Assert.assertEquals((Object)RED, (Object)labelToTest.getBackground().getRGB());
    }

    private Label createTestLabel(String styleSheet, boolean setCompositeBackgroundExplicitly) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        if (setCompositeBackgroundExplicitly) {
            composite.setBackground(this.redColor);
        }
        Label labelToTest = new Label(composite, 0);
        labelToTest.setText("Some label text");
        this.engine.applyStyles((Object)shell, true);
        return labelToTest;
    }
}

