/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.lang.reflect.Method;
import org.eclipse.e4.ui.css.swt.dom.StyledTextElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyledTextScrollbarTest
extends CSSSWTTestCase {
    Shell shell;

    @Before
    public void setUpShell() {
        this.shell = new Shell(this.display, 1264);
    }

    @After
    public void tearDownShell() {
        this.shell.dispose();
    }

    private StyledText createStyledText() {
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        StyledText styledText = new StyledText((Composite)this.shell, 768);
        StringBuffer buf = new StringBuffer(500);
        int i = 0;
        while (i < 1000) {
            buf.append(String.valueOf(i) + "  - This is a really really really really really really long line to be shown in the styled text\n");
            ++i;
        }
        styledText.setText(buf.toString());
        this.shell.setSize(400, 400);
        return styledText;
    }

    @Test
    public void testScrollBar() throws Exception {
        StyledText styledText = this.createStyledText();
        this.engine = this.createEngine("", this.display);
        this.engine.applyStyles((Object)styledText, true);
        StyledTextElement styledTextElement = new StyledTextElement((Composite)styledText, this.engine);
        styledTextElement.setScrollBarForegroundColor(new Color((Device)this.display, 255, 0, 0));
        styledTextElement.setScrollBarBackgroundColor(new Color((Device)this.display, 0, 0, 255));
        styledTextElement.setScrollBarWidth(6);
        styledTextElement.setMouseNearScrollScrollBarWidth(15);
        styledTextElement.setScrollBarBorderRadius(15);
        styledTextElement.setVerticalScrollBarVisible(true);
        styledTextElement.setHorizontalScrollBarVisible(true);
        styledTextElement.setScrollBarThemed("true");
    }

    @Test
    public void testScrollBarEngine() throws Exception {
        StyledText styledText = this.createStyledText();
        StringBuffer buf = new StringBuffer();
        buf.append("StyledText{");
        buf.append("  swt-scrollbar-themed: true;");
        buf.append("  swt-scrollbar-background-color: rgb(0,0,255);");
        buf.append("  swt-scrollbar-foreground-color: rgb(0,255,0);");
        buf.append("  swt-scrollbar-width: 1px;");
        buf.append("  swt-scrollbar-mouse-near-scroll-width: 3;");
        buf.append("  swt-scrollbar-vertical-visible: true;");
        buf.append("  swt-scrollbar-horizontal-visible: false;");
        buf.append("  swt-scrollbar-border-radius: 3;");
        buf.append("}");
        this.engine = this.createEngine(buf.toString(), this.display);
        this.engine.applyStyles((Object)styledText, true);
        Object adapter = styledText.getData("StyledTextThemedScrollBarAdapter");
        Assert.assertEquals((Object)new RGB(0, 0, 255), (Object)((Color)this.invoke(adapter, "getScrollBarBackgroundColor")).getRGB());
        Assert.assertEquals((Object)new RGB(0, 255, 0), (Object)((Color)this.invoke(adapter, "getScrollBarForegroundColor")).getRGB());
        Assert.assertEquals((Object)1, (Object)this.invoke(adapter, "getScrollBarWidth"));
        Assert.assertEquals((Object)true, (Object)this.invoke(adapter, "getVerticalScrollBarVisible"));
        Assert.assertEquals((Object)false, (Object)this.invoke(adapter, "getHorizontalScrollBarVisible"));
        Assert.assertEquals((Object)3, (Object)this.invoke(adapter, "getScrollBarBorderRadius"));
        Assert.assertEquals((Object)true, (Object)this.invoke(adapter, "getScrollBarThemed"));
        Assert.assertEquals((Object)false, (Object)styledText.getVerticalBar().getVisible());
        buf = new StringBuffer();
        buf.append("StyledText{");
        buf.append("  swt-scrollbar-themed: false;");
        buf.append("}");
        this.engine = this.createEngine(buf.toString(), this.display);
        this.engine.applyStyles((Object)styledText, true);
        Assert.assertEquals((Object)false, (Object)this.invoke(adapter, "getScrollBarThemed"));
        Assert.assertTrue((boolean)styledText.getVerticalBar().getVisible());
    }

    private Object invoke(Object adapter, String string) {
        try {
            Method method = adapter.getClass().getMethod(string, new Class[0]);
            return method.invoke(adapter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

