/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.junit.Assert;
import org.junit.Test;

public class Bug459961Test
extends CSSSWTTestCase {
    @Test
    public void testRegularColorConstantReference() {
        String cssString = "Label { background-color: COLOR-GREEN; }";
        Label label = this.createTestLabel(cssString);
        RGBA expected = Display.getDefault().getSystemColor(5).getRGBA();
        RGBA actual = label.getBackground().getRGBA();
        this.assertRGBAEquals(expected, actual);
    }

    @Test
    public void testTransparentColorConstantReference() {
        if (System.getProperty("org.eclipse.swt.internal.gtk.version", "").startsWith("3.")) {
            System.out.println("testTransparentColorConstantReference disabled due to Bug 493640 and 494327");
            return;
        }
        String cssString = "Label { background-color: COLOR-TRANSPARENT; }";
        Label label = this.createTestLabel(cssString);
        RGBA expected = Display.getDefault().getSystemColor(37).getRGBA();
        RGBA actual = label.getBackground().getRGBA();
        this.assertRGBAEquals(expected, actual);
    }

    private void assertRGBAEquals(RGBA expected, RGBA actual) {
        Assert.assertEquals((long)expected.rgb.red, (long)actual.rgb.red);
        Assert.assertEquals((long)expected.rgb.blue, (long)actual.rgb.blue);
        Assert.assertEquals((long)expected.rgb.green, (long)actual.rgb.green);
        Assert.assertEquals((long)expected.alpha, (long)actual.alpha);
    }
}

