/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ButtonTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Button createTestButton(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Button buttonToTest = new Button(panel, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return buttonToTest;
    }

    protected Button createTestArrowButton(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Button buttonToTest = new Button(panel, 4);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return buttonToTest;
    }

    @Test
    public void testColor() {
        Button buttonToTest = this.createTestButton("Button { background-color: #FF0000; color: #0000FF }");
        Assert.assertEquals((Object)RED, (Object)buttonToTest.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    @Test
    public void testFontRegular() {
        Button buttonToTest = this.createTestButton("Button { font: Verdana 16px }");
        Assert.assertEquals((long)1L, (long)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)16L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
    }

    @Test
    public void testFontBold() {
        Button buttonToTest = this.createTestButton("Button { font: Arial 12px; font-weight: bold }");
        Assert.assertEquals((long)1L, (long)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    @Test
    public void testFontItalic() {
        Button buttonToTest = this.createTestButton("Button { font-style: italic }");
        Assert.assertEquals((long)1L, (long)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Ignore
    public void testSelectedPseudo() {
        Button buttonToTest = this.createTestButton("Button { color: #FF0000; }\nButton:selected { color: #0000FF; }");
        Assert.assertEquals((Object)RED, (Object)buttonToTest.getForeground().getRGB());
        buttonToTest.setSelection(true);
        this.engine.applyStyles((Object)buttonToTest.getShell(), true);
        Assert.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    @Test
    public void testAlignment() {
        Button buttonToTest = this.createTestButton("Button { alignment: right; }");
        Assert.assertEquals((long)131072L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: left; }");
        Assert.assertEquals((long)16384L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: center; }");
        Assert.assertEquals((long)0x1000000L, (long)buttonToTest.getAlignment());
    }

    @Test
    public void testAlignment2() {
        Button buttonToTest = this.createTestButton("Button { alignment: trail; }");
        Assert.assertEquals((long)131072L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: lead; }");
        Assert.assertEquals((long)16384L, (long)buttonToTest.getAlignment());
    }

    @Test
    public void testArrowAlignment() {
        Button buttonToTest = this.createTestArrowButton("Button { alignment: up; }");
        Assert.assertEquals((long)128L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: down; }");
        Assert.assertEquals((long)1024L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: left; }");
        Assert.assertEquals((long)16384L, (long)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: right; }");
        Assert.assertEquals((long)131072L, (long)buttonToTest.getAlignment());
    }
}

