/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CTabItemElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CTabItemTest
extends CSSSWTTestCase {
    private Shell shell;

    @Override
    @After
    public void tearDown() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        super.tearDown();
    }

    private void spinEventLoop() {
        int i = 0;
        while (i < 3) {
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }

    private CTabFolder createFolder(Composite composite) {
        CTabFolder folderToTest = new CTabFolder(composite, 2048);
        int i = 0;
        while (i < 4) {
            CTabItem item = new CTabItem(folderToTest, 0);
            item.setText("Item " + i);
            Button control = new Button((Composite)folderToTest, 8);
            item.setControl((Control)control);
            ++i;
        }
        folderToTest.setSelection(0);
        return folderToTest;
    }

    private CTabFolder createTestTabFolder() {
        return this.createTestTabFolder(true);
    }

    private CTabFolder createTestTabFolder(boolean open) {
        this.shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        CTabFolder folderToTest = this.createFolder((Composite)this.shell);
        if (open) {
            this.shell.open();
        }
        return folderToTest;
    }

    private CTabFolder createTestTabFolder(String styleSheet) {
        return this.createTestTabFolder(styleSheet, true);
    }

    protected CTabFolder createTestTabFolder(String styleSheet, boolean open) {
        CTabFolder folder = this.createTestTabFolder(open);
        this.engine = this.createEngine(styleSheet, folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        return folder;
    }

    @Test
    public void testFontRegular() {
        CTabFolder folder = this.createTestTabFolder("Button { font-family: Verdana; font-size: 12 }\nCTabItem { font-family: Verdana; font-size: 16 }");
        this.spinEventLoop();
        folder.getItems();
        Assert.assertEquals((long)0L, (long)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)16L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
        Assert.assertEquals((Object)"Verdana", (Object)this.engine.retrieveCSSProperty((Object)item, "font-family", null));
        Assert.assertEquals((Object)"16", (Object)this.engine.retrieveCSSProperty((Object)item, "font-size", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
    }

    @Test
    public void testFontBold() {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-weight: bold }");
        this.spinEventLoop();
        Assert.assertEquals((long)0L, (long)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
        Assert.assertEquals((Object)"bold", (Object)this.engine.retrieveCSSProperty((Object)item, "font-weight", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    @Test
    public void testFontItalic() {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-style: italic }");
        this.spinEventLoop();
        Assert.assertEquals((long)0L, (long)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
        Assert.assertEquals((Object)"italic", (Object)this.engine.retrieveCSSProperty((Object)item, "font-style", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    private void testSelectedFontBold(CTabFolder folder, int selectionIndex) {
        folder.setSelection(selectionIndex);
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            if (i == selectionIndex) {
                Assert.assertEquals((long)1L, (long)fontData.getStyle());
            } else {
                Assert.assertEquals((long)0L, (long)fontData.getStyle());
            }
            ++i;
        }
    }

    @Test
    public void testSelectedFontBold() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedFontBold(folder, i);
            ++i;
        }
    }

    @Test
    public void testSelectedFontMerged() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: normal; font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assert.assertEquals((long)3L, (long)fd.getStyle());
            } else {
                Assert.assertEquals((long)2L, (long)fd.getStyle());
            }
            ++i;
        }
    }

    @Test
    public void testSelectedFontMerged2() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assert.assertEquals((long)3L, (long)fd.getStyle());
            } else {
                Assert.assertEquals((long)2L, (long)fd.getStyle());
            }
            ++i;
        }
    }

    @Test
    public void testSelectedFontMerged3() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: bold }\nCTabItem:selected { font-style: italic; font-weight: normal }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItem item = folder.getItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assert.assertEquals((long)2L, (long)fd.getStyle());
            } else {
                Assert.assertEquals((long)1L, (long)fd.getStyle());
            }
            ++i;
        }
    }

    private void testShowClose(boolean showClose) {
        CTabItem[] items;
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: " + Boolean.toString(showClose) + " }");
        CTabItem[] cTabItemArray = items = folder.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assert.assertEquals((Object)showClose, (Object)item.getShowClose());
            Assert.assertEquals((Object)Boolean.toString(showClose), (Object)this.engine.retrieveCSSProperty((Object)item, "show-close", null));
            ++n2;
        }
    }

    @Test
    public void testShowCloseFalse() {
        this.testShowClose(false);
    }

    @Test
    public void testShowCloseTrue() {
        this.testShowClose(true);
    }

    @Test
    public void testShowClose() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)true, (Object)folder.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("CTabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)false, (Object)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    @Test
    public void testShowClose2() {
        CTabFolder folder = this.createTestTabFolder();
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        this.engine = this.createEngine("CTabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)true, (Object)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            Assert.assertEquals((Object)true, (Object)folder2.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("CTabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)false, (Object)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)false, (Object)folder2.getItem(i).getShowClose());
            ++i;
        }
    }

    private void testSelectedShowClose(CTabFolder folder, int index) {
        CTabItem[] items = folder.getItems();
        folder.setSelection(index);
        this.spinEventLoop();
        int i = 0;
        while (i < items.length) {
            if (i == index) {
                Assert.assertEquals((Object)true, (Object)items[i].getShowClose());
                Assert.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            } else {
                Assert.assertEquals((Object)false, (Object)items[i].getShowClose());
                Assert.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            }
            ++i;
        }
    }

    @Test
    public void testSelectedShowClose() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
        this.engine = this.createEngine("CTabItem:selected { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertFalse((boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    @Test
    public void testSelectedShowClose2() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { show-close: false }\nCTabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
    }

    @Ignore(value="test was commented before bug 443094")
    @Test
    public void testClassSelectedShowClose() {
        CTabFolder folder = this.createTestTabFolder();
        WidgetElement.setCSSClass((Widget)folder, (String)"editorStack");
        CSSEngine engine = this.createEngine("CTabFolder.editorStack CTabItem { show-close: true }", folder.getDisplay());
        engine.applyStyles((Object)folder.getShell(), true);
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertTrue((boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    @Ignore(value="test was commented before bug 443094")
    @Test
    public void testFontsEditorStackClass() {
        FontData data;
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { font-size: 10 }CTabItem:selected { font-size: 14; font-weight: bold }CTabFolder.editorStack CTabItem { font-size: 11; }CTabFolder.editorStack CTabItem:selected { font-size: 13; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assert.assertNotNull((Object)folder.getSelection());
        Assert.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assert.assertEquals((long)14L, (long)data.getHeight());
                Assert.assertEquals((long)1L, (long)data.getStyle());
            } else {
                Assert.assertEquals((long)10L, (long)data.getHeight());
                Assert.assertEquals((long)0L, (long)data.getStyle());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            data = item.getFont().getFontData()[0];
            Assert.assertEquals((long)11L, (long)data.getHeight());
            Assert.assertEquals((long)0L, (long)data.getStyle());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                Assert.assertEquals((long)13L, (long)data.getHeight());
                Assert.assertEquals((long)3L, (long)data.getStyle());
            } else {
                Assert.assertEquals((long)11L, (long)data.getHeight());
                Assert.assertEquals((long)0L, (long)data.getStyle());
            }
            ++i;
        }
    }

    @Ignore(value="test was commented before bug 443094")
    @Test
    public void testFontsEditorStackClass2() {
        FontData data;
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { font-size: 10 }CTabItem:selected { font-size: 14; font-weight: bold }CTabFolder.editorStack CTabItem { font-size: 11; }CTabFolder.editorStack CTabItem:selected { font-size: 13; font-weight: normal; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assert.assertNotNull((Object)folder.getSelection());
        Assert.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assert.assertEquals((long)14L, (long)data.getHeight());
                Assert.assertEquals((long)1L, (long)data.getStyle());
            } else {
                Assert.assertEquals((long)10L, (long)data.getHeight());
                Assert.assertEquals((long)0L, (long)data.getStyle());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            data = item.getFont().getFontData()[0];
            Assert.assertEquals((long)11L, (long)data.getHeight());
            Assert.assertEquals((long)0L, (long)data.getStyle());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                Assert.assertEquals((long)13L, (long)data.getHeight());
                Assert.assertEquals((long)2L, (long)data.getStyle());
            } else {
                Assert.assertEquals((long)11L, (long)data.getHeight());
                Assert.assertEquals((long)0L, (long)data.getStyle());
            }
            ++i;
        }
    }

    @Ignore(value="test was commented before bug 443094")
    @Test
    public void testShowCloseEditorStack() {
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { show-close: false }CTabItem:selected { show-close: true }CTabFolder.editorStack CTabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assert.assertNotNull((Object)folder.getSelection());
        Assert.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getItem(i);
            if (item == folder.getSelection()) {
                Assert.assertTrue((boolean)item.getShowClose());
            } else {
                Assert.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            Assert.assertTrue((boolean)item.getShowClose());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            Assert.assertTrue((boolean)item.getShowClose());
            ++i;
        }
    }

    @Ignore(value="test was commented before bug 443094")
    @Test
    public void testShowCloseViewStack() {
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"viewStack");
        this.engine = this.createEngine("CTabItem { show-close: false }CTabItem:selected { show-close: true }CTabFolder.viewStack CTabItem { show-close: false }CTabFolder.viewStack CTabItem.selected { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assert.assertNotNull((Object)folder.getSelection());
        Assert.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getItem(i);
            if (item == folder.getSelection()) {
                Assert.assertTrue((boolean)item.getShowClose());
            } else {
                Assert.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getItem(i);
            Assert.assertFalse((boolean)item.getShowClose());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder.getItem(i);
            if (item == folder.getSelection()) {
                Assert.assertTrue((boolean)item.getShowClose());
            } else {
                Assert.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
    }

    @Test
    public void testBackground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { background-color: #0000ff }", false);
        Assert.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)"#0000ff", (Object)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
    }

    @Test
    public void testBackground2() {
        CTabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionBackground = folder.getSelectionBackground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionBackground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("CTabItem { background-color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        Assert.assertEquals((Object)rgb, (Object)folder.getBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)colour, (Object)engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
        Assert.assertEquals((Object)preStyledSelectionBackground.getRGB(), (Object)folder.getSelectionBackground().getRGB());
    }

    @Test
    public void testSelectionBackground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { background-color: #00ff00 }", false);
        Assert.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)"#00ff00", (Object)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", "selected"));
            ++i;
        }
    }

    @Test
    public void testForeground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { color: #0000ff }", false);
        Assert.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)"#0000ff", (Object)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "color", null));
            ++i;
        }
    }

    @Test
    public void testForeground2() {
        CTabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionForeground = folder.getSelectionForeground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionForeground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("CTabItem { color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        Assert.assertEquals((Object)rgb, (Object)folder.getForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)colour, (Object)engine.retrieveCSSProperty((Object)folder.getItem(i), "color", null));
            ++i;
        }
        Assert.assertEquals((Object)preStyledSelectionForeground.getRGB(), (Object)folder.getSelectionForeground().getRGB());
    }

    @Test
    public void testSelectionForeground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { color: #00ff00 }", false);
        Assert.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            Assert.assertEquals((Object)"#00ff00", (Object)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "color", "selected"));
            ++i;
        }
    }

    @Test
    public void testParent() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { color: #00ff00 }", false);
        int i = 0;
        while (i < folder.getItemCount()) {
            CTabItemElement element = (CTabItemElement)this.engine.getElement((Object)folder.getItem(i));
            Assert.assertNotNull((Object)element.getParentNode());
            ++i;
        }
    }
}

