/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.HashSet;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class ShellTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Shell createTestShell(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    @Test
    public void testColor() {
        Shell shellToTest = this.createTestShell("Shell { background-color: #FF0000; color: #0000FF }");
        Assert.assertEquals((Object)RED, (Object)shellToTest.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)shellToTest.getForeground().getRGB());
    }

    @Test
    public void testFontRegular() {
        Shell shellToTest = this.createTestShell("Shell { font: Verdana 16px }");
        Assert.assertEquals((long)1L, (long)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)16L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
    }

    @Test
    public void testFontBold() {
        Shell shellToTest = this.createTestShell("Shell { font: Arial 12px; font-weight: bold }");
        Assert.assertEquals((long)1L, (long)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    @Test
    public void testFontItalic() {
        Shell shellToTest = this.createTestShell("Shell { font-style: italic }");
        Assert.assertEquals((long)1L, (long)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void test375069ChildShellDifferentiation() {
        this.engine = this.createEngine("Shell.parent { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
        Assert.assertEquals((long)1L, (long)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assert.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    @Test
    public void test375069AllShell() {
        this.engine = this.createEngine("Shell { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
        Assert.assertEquals((long)1L, (long)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void testShellParentage() {
        this.engine = this.createEngine("Shell[parentage='parent'] { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setID((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setID((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertNotSame((Object)2, (Object)fontData.getStyle());
        Assert.assertEquals((long)1L, (long)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void testShellUnparentedPseudoelement() {
        this.engine = this.createEngine("Shell:swt-unparented { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
        Assert.assertEquals((long)1L, (long)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assert.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    @Test
    public void testShellParentedPseudoelement() {
        this.engine = this.createEngine("Shell:swt-parented { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertNotSame((Object)2, (Object)fontData.getStyle());
        Assert.assertEquals((long)1L, (long)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void testSwtDataClassAttribute() {
        this.engine = this.createEngine("Shell[swt-data-class ~= 'java.util.HashSet'] { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        parent.setData(new HashSet());
        parent.open();
        this.engine.applyStyles((Object)parent, true);
        Assert.assertEquals((long)1L, (long)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void testBackgroundMode() {
        Shell shellToTest = this.createTestShell("Shell { swt-background-mode: force; }");
        Assert.assertEquals((long)2L, (long)shellToTest.getBackgroundMode());
    }
}

