/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EModelServiceInsertTest {
    private IEclipseContext applicationContext;
    MApplication app = null;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        this.ems = (EModelService)this.applicationContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        this.applicationContext.dispose();
    }

    private MApplication createSimpleApplication() {
        MApplication app = (MApplication)this.ems.createModelElement(MApplication.class);
        app.setContext(this.applicationContext);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setElementId("main.Window");
        app.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("theStack");
        window.getChildren().add(stack);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        part1.setElementId("part1");
        stack.getChildren().add(part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        part2.setElementId("part2");
        stack.getChildren().add(part2);
        return app;
    }

    private MApplication createApplication() {
        MApplication app = (MApplication)this.ems.createModelElement(MApplication.class);
        app.setContext(this.applicationContext);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setElementId("main.Window");
        app.getChildren().add(window);
        MPartSashContainer psc = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        psc.setHorizontal(true);
        psc.setElementId("topSash");
        window.getChildren().add(psc);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("theStack");
        psc.getChildren().add(stack);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        part1.setElementId("part1");
        stack.getChildren().add(part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        part2.setElementId("part2");
        stack.getChildren().add(part2);
        return app;
    }

    private void testInsert(MApplication app, String relToId, int where, float ratio) {
        EModelService modelService = (EModelService)app.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        MUIElement relTo = modelService.find(relToId, (MUIElement)app);
        MPart newPart = (MPart)this.ems.createModelElement(MPart.class);
        newPart.setElementId("newPart");
        modelService.insert((MPartSashContainerElement)newPart, (MPartSashContainerElement)relTo, where, ratio);
        MElementContainer newPartParent = newPart.getParent();
        Assert.assertTrue((String)"parent must be a sash", (boolean)(newPartParent instanceof MPartSashContainer));
        MPartSashContainer psc = (MPartSashContainer)newPartParent;
        boolean horizontal = where == 2 || where == 3;
        Assert.assertTrue((String)"invalid sash orientation", (psc.isHorizontal() == horizontal ? 1 : 0) != 0);
        if (where == 2 || where == 0) {
            Assert.assertTrue((String)"new part should be first", (psc.getChildren().indexOf(newPart) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"old part should be second", (psc.getChildren().indexOf(relTo) == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"old part should be first", (psc.getChildren().indexOf(relTo) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"new part should be second", (psc.getChildren().indexOf(newPart) == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimpleInsertAbove() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 0, 0.25f);
    }

    @Test
    public void testSimpleInsertBelow() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 1, 0.25f);
    }

    @Test
    public void testSimpleInsertLeftOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 2, 0.25f);
    }

    @Test
    public void testSimpleInsertRightOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 3, 0.25f);
    }

    @Test
    public void testInsertAbove() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 0, 0.35f);
    }

    @Test
    public void testInsertBelow() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 1, 0.35f);
    }

    @Test
    public void testInsertLeftOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 2, 0.35f);
    }

    @Test
    public void testInsertRightOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 3, 0.35f);
    }

    @Test
    public void testInsertRightOfSharedStack() {
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class.getName());
        Assert.assertNotNull((Object)modelService);
        this.app = (MApplication)modelService.createModelElement(MApplication.class);
        this.app.setContext(this.applicationContext);
        MWindow window = (MWindow)modelService.createModelElement(MWindow.class);
        window.setElementId("main.Window");
        this.app.getChildren().add(window);
        MPartSashContainer psc = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
        psc.setHorizontal(true);
        psc.setElementId("topSash");
        window.getChildren().add(psc);
        MPartStack sharedStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        sharedStack.setElementId("sharedStack");
        window.getSharedElements().add(sharedStack);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        part1.setElementId("part1");
        sharedStack.getChildren().add(part1);
        MPlaceholder sharedStackRef = (MPlaceholder)modelService.createModelElement(MPlaceholder.class);
        sharedStackRef.setElementId(sharedStack.getElementId());
        sharedStackRef.setRef((MUIElement)sharedStack);
        psc.getChildren().add(sharedStackRef);
        MPart newPart = (MPart)modelService.createModelElement(MPart.class);
        newPart.setElementId("part2");
        modelService.insert((MPartSashContainerElement)newPart, (MPartSashContainerElement)sharedStack, 1, 0.5f);
    }
}

