/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ElementMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EModelServicePerspectiveFindTest {
    @Parameterized.Parameter
    public boolean simple;
    private IEclipseContext applicationContext;
    private EModelService modelService;
    private MApplication app = null;
    private MWindow window;
    private MPerspectiveStack perspectiveStack;
    private MPart partA;
    private MPart partB;
    private MPart outerPart;
    private Selector selectAll;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{true, false};
    }

    @Before
    public void setUp() {
        this.applicationContext = E4Application.createDefaultContext();
        this.modelService = (EModelService)this.applicationContext.get(EModelService.class);
        this.selectAll = new ElementMatcher(null, null, null);
        if (this.simple) {
            this.setupSimpleApplication();
        } else {
            this.setupWorkbenchApplication();
        }
    }

    @After
    public void tearDown() {
        this.applicationContext.dispose();
    }

    private void setupSimpleApplication() {
        this.app = (MApplication)this.modelService.createModelElement(MApplication.class);
        this.app.setContext(this.applicationContext);
        this.window = (MWindow)this.modelService.createModelElement(MWindow.class);
        this.window.setElementId("singleValidId");
        this.app.getChildren().add(this.window);
        this.setupPerspectiveStack();
        this.window.getChildren().add(this.perspectiveStack);
        this.outerPart = (MPart)this.modelService.createModelElement(MPart.class);
        MPartStack outerPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        outerPartStack.getChildren().add(this.outerPart);
        this.window.getChildren().add(outerPartStack);
        this.window.setSelectedElement((MUIElement)this.perspectiveStack);
    }

    private void setupWorkbenchApplication() {
        this.app = (MApplication)this.modelService.createModelElement(MApplication.class);
        this.app.setContext(this.applicationContext);
        this.window = (MWindow)this.modelService.createModelElement(MWindow.class);
        this.window.setElementId("singleValidId");
        this.app.getChildren().add(this.window);
        MPartSashContainer topPSC = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
        this.window.getChildren().add(topPSC);
        this.setupPerspectiveStack();
        topPSC.getChildren().add(this.perspectiveStack);
        MPartStack outerPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        this.outerPart = (MPart)this.modelService.createModelElement(MPart.class);
        outerPartStack.getChildren().add(this.outerPart);
        topPSC.getChildren().add(outerPartStack);
        this.window.setSelectedElement((MUIElement)topPSC);
        topPSC.setSelectedElement((MUIElement)this.perspectiveStack);
    }

    private void setupPerspectiveStack() {
        this.perspectiveStack = (MPerspectiveStack)this.modelService.createModelElement(MPerspectiveStack.class);
        MPerspective perspectiveA = (MPerspective)this.modelService.createModelElement(MPerspective.class);
        this.perspectiveStack.getChildren().add(perspectiveA);
        MPartStack partStackA = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        this.partA = (MPart)this.modelService.createModelElement(MPart.class);
        partStackA.getChildren().add(this.partA);
        MPerspective perspectiveB = (MPerspective)this.modelService.createModelElement(MPerspective.class);
        this.perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        this.partB = (MPart)this.modelService.createModelElement(MPart.class);
        partStackB.getChildren().add(this.partB);
        this.perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
    }

    @Test
    public void testInActivePerspective() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 2, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)this.partA, elements.get(0));
    }

    @Test
    public void testInAnyPerspective() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 4, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)2L, (long)elements.size());
        Assert.assertTrue((boolean)elements.contains(this.partA));
        Assert.assertTrue((boolean)elements.contains(this.partB));
    }

    @Test
    public void testOuterPerspective() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 1, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertTrue((boolean)elements.contains(this.outerPart));
    }

    @Test
    public void testInTrim() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 16, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void testPresentation() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 11, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)2L, (long)elements.size());
        Assert.assertTrue((boolean)elements.contains(this.partA));
        Assert.assertTrue((boolean)elements.contains(this.outerPart));
    }

    @Test
    public void testAnywhere() {
        List elements = this.modelService.findElements((MApplicationElement)this.window, MPart.class, 29, this.selectAll);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)3L, (long)elements.size());
        Assert.assertTrue((boolean)elements.contains(this.partA));
        Assert.assertTrue((boolean)elements.contains(this.partB));
        Assert.assertTrue((boolean)elements.contains(this.outerPart));
    }
}

