/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.tests.application.HeadlessStartupTest;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceHandlerTest
extends HeadlessStartupTest {
    private ServiceTracker locationTracker;

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            BundleContext context = FrameworkUtil.getBundle(ResourceHandlerTest.class).getBundleContext();
            Filter filter = null;
            try {
                filter = context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.locationTracker = new ServiceTracker(context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    private ResourceHandler createHandler(URI uri) {
        IEclipseContext localContext = this.applicationContext.createChild();
        localContext.set("instanceLocation", (Object)this.getInstanceLocation());
        localContext.set("persistState", (Object)Boolean.TRUE);
        localContext.set("clearPersistedState", (Object)Boolean.TRUE);
        localContext.set("initialWorkbenchModelURI", (Object)uri);
        return (ResourceHandler)ContextInjectionFactory.make(ResourceHandler.class, (IEclipseContext)localContext);
    }

    @Test
    public void testModelProcessor() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        MApplication application = (MApplication)resource.getContents().get(0);
        Assert.assertNotNull((Object)application);
        Assert.assertEquals((long)2L, (long)application.getChildren().size());
        Assert.assertEquals((Object)"fragment.contributedWindow", (Object)((MWindow)application.getChildren().get(1)).getElementId());
        Assert.assertEquals((Object)"_w4fQ8HVHEd-aXt9fFntEtw", (Object)((E4XMIResource)resource).getID((EObject)application.getChildren().get(1)));
        Assert.assertEquals((Object)"_rdlLgJQUEd-6X_lmWgGEDA", (Object)((E4XMIResource)resource).getID((EObject)((MWindow)application.getChildren().get(1)).getChildren().get(0)));
        Assert.assertEquals((Object)"platform:/plugin/org.eclipse.e4.ui.tests", (Object)((MWindow)application.getChildren().get(1)).getContributorURI());
        Assert.assertEquals((Object)"platform:/plugin/org.eclipse.e4.ui.tests", (Object)((MWindowElement)((MWindow)application.getChildren().get(1)).getChildren().get(0)).getContributorURI());
        if (application.getHandlers().size() > 2) {
            String check = "bundleclass://org.eclipse.e4.tools.emf.liveeditor/org.eclipse.e4.tools.emf.liveeditor.OpenLiveDialogHandler";
            if (check.equals(((MHandler)application.getHandlers().get(0)).getContributionURI())) {
                application.getHandlers().remove(0);
            } else if (check.equals(((MHandler)application.getHandlers().get(1)).getContributionURI())) {
                application.getHandlers().remove(1);
            }
        }
        Assert.assertTrue((application.getHandlers().size() > 0 ? 1 : 0) != 0);
        Assert.assertSame(application.getCommands().get(0), (Object)((MHandler)application.getHandlers().get(0)).getCommand());
        Assert.assertEquals((long)2L, (long)((MCommand)application.getCommands().get(0)).getParameters().size());
        Assert.assertEquals((long)1L, (long)((MWindow)application.getChildren().get(1)).getVariables().size());
        Assert.assertNotNull((Object)((MWindow)application.getChildren().get(0)).getMainMenu());
        Assert.assertEquals((long)8L, (long)((MWindow)application.getChildren().get(0)).getChildren().size());
        Assert.assertEquals((Object)"fragment.contributedPosFirst", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(0)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedBeforePart1", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(1)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedAfterPart1", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(3)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedPos1", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(4)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedBeforePart2", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(5)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedAfterPart2", (Object)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(7)).getElementId());
    }

    @Test
    public void testXPathModelProcessor() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        MApplication application = (MApplication)resource.getContents().get(0);
        Assert.assertNotNull((Object)application);
        MMenu mainMenu = ((MWindow)application.getChildren().get(0)).getMainMenu();
        Assert.assertNotNull((Object)mainMenu);
        MMenu menu1 = (MMenu)this.findByElementId(mainMenu.getChildren(), "fragment.contributedMenu1");
        Assert.assertNotNull((Object)menu1);
        MMenu menu2 = (MMenu)this.findByElementId(mainMenu.getChildren(), "fragment.contributedMenu2");
        Assert.assertNotNull((Object)menu2);
        Assert.assertNotNull((Object)this.findByElementId(menu1.getChildren(), "fragment.contributedMenuItem.csv"));
        Assert.assertNotNull((Object)this.findByElementId(menu2.getChildren(), "fragment.contributedMenuItem.csv"));
        Assert.assertNotNull((Object)this.findByElementId(menu1.getChildren(), "fragment.contributedMenuItem.xpath"));
        Assert.assertNotNull((Object)this.findByElementId(menu2.getChildren(), "fragment.contributedMenuItem.xpath"));
    }

    private Object findByElementId(List<MMenuElement> children, String id) {
        for (MMenuElement item : children) {
            if (!id.equals(item.getElementId())) continue;
            return item;
        }
        return null;
    }
}

