/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.internal.extensions.util.EventUtils;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;

public class InjectionEventTest {
    protected static boolean testFailed = false;
    private EventAdminHelper helper;

    @Before
    public void setUp() throws Exception {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.helper = (EventAdminHelper)ContextInjectionFactory.make(EventAdminHelper.class, (IEclipseContext)localContext);
    }

    @Test
    public void testEventInjection() {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        IEclipseContext context = EclipseContextFactory.create();
        final Display d = Display.getDefault();
        context.set(Realm.class, (Object)DisplayRealm.getRealm((Display)d));
        context.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                d.syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                d.asyncExec(runnable);
            }
        });
        ContextInjectionFactory.setDefault((IEclipseContext)context);
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)target.counter1);
        Assert.assertNull((Object)target.string1);
        Assert.assertEquals((long)0L, (long)target.counter2);
        Assert.assertNull((Object)target.string2);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "event1data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)0L, (long)target.counter2);
        Assert.assertNull((Object)target.string2);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event2", "event2data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter2);
        Assert.assertEquals((Object)"event2data", (Object)target.string2);
        Assert.assertEquals((long)1L, (long)target.counter3);
        Assert.assertNull((Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event3", "event3data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter2);
        Assert.assertEquals((Object)"event2data", (Object)target.string2);
        Assert.assertEquals((long)2L, (long)target.counter3);
        Assert.assertEquals((Object)"event3data", (Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "abc");
        Assert.assertEquals((long)2L, (long)target.counter1);
        Assert.assertEquals((Object)"abc", (Object)target.string1);
        Assert.assertEquals((long)1L, (long)target.counter2);
        Assert.assertEquals((Object)"event2data", (Object)target.string2);
        Assert.assertEquals((long)2L, (long)target.counter3);
        Assert.assertEquals((Object)"event3data", (Object)target.string3);
        Assert.assertNotNull((Object)target.myBinding);
    }

    @Test
    public void testEventInjectionUnsubscribe() {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        this.wrapSetup();
        System.gc();
        System.runFinalization();
        System.gc();
        this.helper.sendEvent("e4/test/event1", "wrong");
        Assert.assertFalse((boolean)testFailed);
    }

    @Test
    public void testInjectWildCard() {
        IEclipseContext context = EclipseContextFactory.create();
        final Display d = Display.getDefault();
        context.set(Realm.class, (Object)DisplayRealm.getRealm((Display)d));
        context.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                d.syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                d.asyncExec(runnable);
            }
        });
        InjectStarEvent target = (InjectStarEvent)ContextInjectionFactory.make(InjectStarEvent.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)target.counter1);
        Assert.assertNull((Object)target.data);
        this.helper.sendEvent("e4/test/eventInjection", "sample");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"sample", (Object)target.data);
    }

    private void wrapSetup() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        this.helper.sendEvent("e4/test/event1", "event1data");
        Assert.assertEquals((long)1L, (long)target.counter1);
        Assert.assertEquals((Object)"event1data", (Object)target.string1);
        target.valid = false;
    }

    public static class EventAdminHelper {
        @Inject
        public EventAdmin eventAdmin;

        public void sendEvent(String topic, Object data) {
            EventUtils.send((EventAdmin)this.eventAdmin, (String)topic, (Object)data);
        }
    }

    static class InjectStarEvent {
        public int counter1 = 0;
        public String data;

        InjectStarEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@UIEventTopic(value="e4/test/*") String data) {
            ++this.counter1;
            this.data = data;
        }
    }

    static class InjectTarget {
        public int counter1 = 0;
        public int counter2 = 0;
        public int counter3 = 0;
        public String string1;
        public String string2;
        public String string3;
        public boolean valid = true;
        public MyBinding myBinding;

        InjectTarget() {
        }

        public void resetCounters() {
            this.counter3 = 0;
            this.counter2 = 0;
            this.counter1 = 0;
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/event1") String string1) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter1;
            this.string1 = string1;
        }

        @Inject
        @Optional
        public void receivedEvent2(@UIEventTopic(value="e4/test/event2") String string2) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter2;
            this.string2 = string2;
        }

        @Inject
        public void receivedOptionalEvent(MyBinding myBinding, @Optional @EventTopic(value="e4/test/event3") String string3) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter3;
            this.myBinding = myBinding;
            this.string3 = string3;
        }
    }

    @Singleton
    static class MyBinding {
        MyBinding() {
        }
    }
}

