/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MPartSashContainerTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testPartSashContainer_Horizontal() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.setHorizontal(true);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(partSashContainer);
        partSashContainer.getChildren().add(partA);
        partSashContainer.getChildren().add(partB);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = partSashContainer.getWidget();
        Assert.assertNotNull((Object)widget);
    }
}

