/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MPartTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testSetName() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertEquals((Object)"Part Name", (Object)item.getText());
        part.setLabel("Another Name");
        Assert.assertEquals((Object)"Another Name", (Object)item.getText());
    }

    @Test
    public void testCTabItem_GetImage() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertNotNull((Object)item.getImage());
    }

    private void testDeclaredName(String declared, String expected) {
        MWindow window = this.createWindowWithOneView(declared);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertEquals((Object)expected, (Object)item.getText());
    }

    @Test
    public void testDeclaredNameNull() {
        this.testDeclaredName(null, "");
    }

    @Test
    public void testDeclaredNameEmpty() {
        this.testDeclaredName("", "");
    }

    @Test
    public void testDeclaredNameDefined() {
        this.testDeclaredName("partName", "partName");
    }

    private void testDeclaredTooltip(String partToolTip, String expectedToolTip) {
        MWindow window = this.createWindowWithOneView("Part Name", partToolTip);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertEquals((Object)expectedToolTip, (Object)item.getToolTipText());
    }

    @Test
    public void testDeclaredTooltipNull() {
        this.testDeclaredTooltip(null, null);
    }

    @Test
    public void testDeclaredTooltipEmptyString() {
        this.testDeclaredTooltip("", null);
    }

    @Test
    public void testDeclaredTooltipDefined() {
        this.testDeclaredTooltip("partToolTip", "partToolTip");
    }

    private void testMPart_setTooltip(String partToolTip, String expectedToolTip) {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertEquals(null, (Object)item.getToolTipText());
        part.setTooltip(partToolTip);
        Assert.assertEquals((Object)expectedToolTip, (Object)item.getToolTipText());
    }

    @Test
    public void testMPart_setTooltipNull() {
        this.testMPart_setTooltip(null, null);
    }

    @Test
    public void testMPart_setTooltipEmptyString() {
        this.testMPart_setTooltip("", null);
    }

    @Test
    public void testMPart_setTooltipDefined() {
        this.testMPart_setTooltip("partToolTip", "partToolTip");
    }

    @Test
    public void testMPart_getContext() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        renderer.removeGui((MUIElement)part);
        Assert.assertNull((Object)part.getContext());
    }

    @Test
    public void testMPartBug369866() {
        MWindow window = this.createWindowWithOneView("Part");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertFalse((boolean)part.isDirty());
        Assert.assertEquals((Object)"Part", (Object)item.getText());
        part.setDirty(true);
        Assert.assertEquals((Object)"*Part", (Object)item.getText());
        part.setLabel("");
        Assert.assertEquals((Object)"*", (Object)item.getText());
        part.setDirty(false);
        Assert.assertEquals((Object)"", (Object)item.getText());
        part.setDirty(true);
        Assert.assertEquals((Object)"*", (Object)item.getText());
    }

    private MWindow createWindowWithOneView(String partName) {
        return this.createWindowWithOneView(partName, null);
    }

    private MWindow createWindowWithOneView(String partName, String toolTip) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setTooltip(toolTip);
        contributedPart.setIconURI("platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.png");
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

