/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactorySimple;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.fragment.MFragmentFactory;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class ModelAssemblerTests {
    private static final String EXTENSION_POINT_ID = "org.eclipse.e4.workbench.model";
    private static final String BUNDLE_SYMBOLIC_NAME = "org.eclipse.e4.ui.tests";
    private static final String APPLICATION_ID = "org.eclipse.e4.ui.tests.modelassembler.app";
    private IEclipseContext appContext;
    private MApplication application;
    private E4XMIResourceFactory factory;
    private ResourceSetImpl resourceSet;
    private E4XMIResource appResource;
    private ModelAssembler assembler;
    private Logger logger;

    @Before
    public void setup() {
        this.appContext = E4Application.createDefaultContext();
        this.application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        this.application.setElementId(APPLICATION_ID);
        this.application.setContext(this.appContext);
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.appContext.set(Logger.class, (Object)this.logger);
        this.appContext.set(MApplication.class, (Object)this.application);
        this.factory = new E4XMIResourceFactory();
        this.appResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"virtualuri"));
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResources().add((Object)this.appResource);
        this.appResource.getContents().add((Object)((EObject)this.application));
        this.assembler = new ModelAssembler();
        ContextInjectionFactory.inject((Object)this.assembler, (IEclipseContext)this.appContext);
    }

    @Test
    public void testFragments_emptyFragment() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_emptyFragment_contribURI", true);
        Assert.assertTrue((boolean)elements.isEmpty());
        EModelService modelService = (EModelService)this.application.getContext().get(EModelService.class);
        List modelElements = modelService.findElements((MApplicationElement)this.application, MApplicationElement.class, 29, new Selector(){

            public boolean select(MApplicationElement element) {
                return element.getContributorURI() != null && element.getContributorURI().equals("testFragments_emptyFragment_contribURI");
            }
        });
        Assert.assertTrue((boolean)modelElements.isEmpty());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testFragments_workingFragment() throws Exception {
        MWindow window = MBasicFactory.INSTANCE.createWindow();
        window.setElementId("testFragments_workingFragment-contributedWindow");
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        fragment.setParentElementId(APPLICATION_ID);
        fragment.getElements().add(window);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        EModelService modelService = (EModelService)this.application.getContext().get(EModelService.class);
        Assert.assertEquals(null, (Object)modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application));
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_emptyFragment_contribURI", false);
        Assert.assertEquals((Object)window, (Object)modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application));
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)"testFragments_emptyFragment_contribURI", (Object)((MApplicationElement)elements.get(0)).getContributorURI());
        Assert.assertTrue((boolean)elements.contains(window));
        MUIElement found = modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)window, (Object)found);
        Assert.assertEquals((Object)APPLICATION_ID, (Object)found.getParent().getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    @Ignore
    public void testFragments_existingXMIID_checkExists() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        fragment.setParentElementId(APPLICATION_ID);
        E4XMIResource fragmentResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        MWindow window1 = MBasicFactory.INSTANCE.createWindow();
        window1.setElementId("testFragments_existingElementID-contributedWindow");
        MWindow window2 = MBasicFactory.INSTANCE.createWindow();
        window2.setElementId("testFragments_existingElementID-contributedWindow");
        this.application.getChildren().add(window1);
        fragment.getElements().add(window2);
        this.appResource.setID((EObject)window1, "testFragments_existingXMIID_XMIID");
        fragmentResource.setID((EObject)window2, "testFragments_existingXMIID_XMIID");
        window1.setContributorURI("testFragments_existingElementID_contribURI");
        window2.setContributorURI("testFragments_existingElementID_contribURI");
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_existingElementID_contribURI", true);
        Assert.assertEquals((long)0L, (long)elements.size());
        EModelService modelService = (EModelService)this.application.getContext().get(EModelService.class);
        MUIElement found = modelService.find("testFragments_existingElementID-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)window1, (Object)found);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testFragments_existingXMIID_ignoreExists() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        fragment.setParentElementId(APPLICATION_ID);
        E4XMIResource fragmentResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        MWindow window1 = MBasicFactory.INSTANCE.createWindow();
        window1.setElementId("testFragments_existingElementID-contributedWindow");
        MWindow window2 = MBasicFactory.INSTANCE.createWindow();
        window2.setElementId("testFragments_existingElementID-contributedWindow");
        this.application.getChildren().add(window1);
        fragment.getElements().add(window2);
        this.appResource.setID((EObject)window1, "testFragments_existingXMIID_XMIID");
        fragmentResource.setID((EObject)window2, "testFragments_existingXMIID_XMIID");
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_existingElementID_contribURI", false);
        Assert.assertEquals((long)elements.size(), (long)1L);
        EModelService modelService = (EModelService)this.application.getContext().get(EModelService.class);
        MUIElement found = modelService.find("testFragments_existingElementID-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)found, (Object)window2);
        Assert.assertEquals((Object)"testFragments_existingElementID_contribURI", (Object)found.getContributorURI());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testImports() {
        ArrayList<MTrimmedWindow> imports = new ArrayList<MTrimmedWindow>();
        ArrayList<MPlaceholder> addedElements = new ArrayList<MPlaceholder>();
        MTrimmedWindow importWindow1 = MBasicFactory.INSTANCE.createTrimmedWindow();
        importWindow1.setElementId("testImports_emptyList_window1");
        MModelFragments fragment = MFragmentFactory.INSTANCE.createModelFragments();
        fragment.getImports().add(importWindow1);
        imports.add(importWindow1);
        MTrimmedWindow realWindow1 = MBasicFactory.INSTANCE.createTrimmedWindow();
        realWindow1.setElementId("testImports_emptyList_window1");
        this.application.getChildren().add(realWindow1);
        MPlaceholder placeholder = MAdvancedFactory.INSTANCE.createPlaceholder();
        placeholder.setRef((MUIElement)importWindow1);
        addedElements.add(placeholder);
        this.assembler.resolveImports(imports, addedElements);
        Assert.assertEquals((Object)realWindow1, (Object)placeholder.getRef());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testImports_noImportElementId() {
        ArrayList<MTrimmedWindow> imports = new ArrayList<MTrimmedWindow>();
        ArrayList<MPlaceholder> addedElements = new ArrayList<MPlaceholder>();
        MTrimmedWindow importWindow1 = MBasicFactory.INSTANCE.createTrimmedWindow();
        importWindow1.setElementId(null);
        MModelFragments fragment = MFragmentFactory.INSTANCE.createModelFragments();
        fragment.getImports().add(importWindow1);
        imports.add(importWindow1);
        MTrimmedWindow realWindow1 = MBasicFactory.INSTANCE.createTrimmedWindow();
        realWindow1.setElementId("testImports_emptyList_window1");
        this.application.getChildren().add(realWindow1);
        MPlaceholder placeholder = MAdvancedFactory.INSTANCE.createPlaceholder();
        placeholder.setRef((MUIElement)importWindow1);
        addedElements.add(placeholder);
        this.assembler.resolveImports(imports, addedElements);
        Assert.assertEquals(null, (Object)placeholder.getRef());
        ((Logger)Mockito.verify((Object)this.logger)).warn("Could not resolve an import element for 'null'");
        ((Logger)Mockito.verify((Object)this.logger)).warn("Could not resolve import for null");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testModelProcessingOrder() throws Exception {
        MTrimmedWindow trimmedWindow = MBasicFactory.INSTANCE.createTrimmedWindow();
        trimmedWindow.setElementId("testModelProcessingOrder-trimmedWindow");
        this.application.getChildren().add(trimmedWindow);
        MPart part = MBasicFactory.INSTANCE.createPart();
        part.setElementId("testModelProcessingOrder-part");
        trimmedWindow.getChildren().add(part);
        MArea area = MAdvancedFactory.INSTANCE.createArea();
        area.setElementId("testModelProcessingOrder-area");
        trimmedWindow.getChildren().add(area);
        IContributor contributor = ContributorFactorySimple.createContributor((Object)BUNDLE_SYMBOLIC_NAME);
        IExtensionRegistry registry = this.createTestExtensionRegistry();
        Assert.assertEquals((long)0L, (long)registry.getConfigurationElementsFor(EXTENSION_POINT_ID).length);
        String dataFilePath = "org.eclipse.e4.ui.tests/data/ModelAssembler/modelProcessingOrder.xml";
        registry.addContribution(this.getContentsAsInputStream(dataFilePath), contributor, false, null, null, null);
        this.assembler.processModel(true);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPreProcessor_nonPersistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", true, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPreProcessor_persistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", false, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPreProcessor_nonPersistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPreProcessor_persistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", false, false);
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPostProcessor_persistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", false, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPostProcessor_nonPersistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", true, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPostProcessor_NonPersistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testPostProcessor_persistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", false, true);
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testProcessor_noProcessor() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processor_null.xml", true, false);
        ((Logger)Mockito.verify((Object)this.logger)).warn("Unable to create processor null from org.eclipse.e4.ui.tests");
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testProcessor_processorNotFound() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processor_wrongProcessorClass.xml", true, false);
        ((Logger)Mockito.verify((Object)this.logger)).warn("Unable to create processor org.eclipse.e4.ui.tests.workbench.SimplePreProcessor_NotFound from org.eclipse.e4.ui.tests");
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testProcessor_wrongAppId() throws Exception {
        this.application.setElementId("newID");
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, true);
        ((Logger)Mockito.verify((Object)this.logger)).warn("Could not find element with id 'org.eclipse.e4.ui.tests.modelassembler.app'");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.logger});
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
    }

    private void testProcessor(String filePath, boolean initial, boolean afterFragments) throws Exception {
        IContributor contributor = ContributorFactorySimple.createContributor((Object)BUNDLE_SYMBOLIC_NAME);
        IExtensionRegistry registry = this.createTestExtensionRegistry();
        Assert.assertEquals((long)0L, (long)registry.getConfigurationElementsFor(EXTENSION_POINT_ID).length);
        registry.addContribution(this.getContentsAsInputStream(filePath), contributor, false, null, null, null);
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = (IExtension[])new ExtensionsSort().sort((Object[])extPoint.getExtensions());
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        this.assembler.runProcessors(extensions, initial, afterFragments);
    }

    private IExtensionRegistry createTestExtensionRegistry() {
        IExtensionRegistry defaultRegistry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = defaultRegistry.getExtensionPoint(EXTENSION_POINT_ID);
        ExtensionRegistry registry = (ExtensionRegistry)RegistryFactory.createRegistry(null, null, null);
        registry.addExtensionPoint(extensionPoint.getUniqueIdentifier(), extensionPoint.getContributor(), false, extensionPoint.getLabel(), extensionPoint.getSchemaReference(), null);
        this.appContext.set(IExtensionRegistry.class, (Object)registry);
        return registry;
    }

    private InputStream getContentsAsInputStream(String filePath) throws IOException {
        URI uri = URI.createPlatformPluginURI((String)filePath, (boolean)true);
        return URIConverter.INSTANCE.createInputStream(uri);
    }
}

