/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.frameworkadmin.equinox.ParserUtils;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractFwkAdminTest
extends TestCase {
    private ServiceTracker<Object, FrameworkAdmin> fwAdminTracker;
    private File testFolder;

    public AbstractFwkAdminTest(String name) {
        super(name);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                AbstractFwkAdminTest.delete(children[i]);
                ++i;
            }
        }
        return file.delete();
    }

    public FrameworkAdmin getEquinoxFrameworkAdmin() throws BundleException {
        String FILTER_OBJECTCLASS = "(objectClass=" + FrameworkAdmin.class.getName() + ")";
        String filterFwAdmin = "(&" + FILTER_OBJECTCLASS + "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)" + "(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe)" + ")";
        String FWK_ADMIN_EQ = "org.eclipse.equinox.frameworkadmin.equinox";
        Bundle b = Platform.getBundle((String)FWK_ADMIN_EQ);
        if (b == null) {
            throw new IllegalStateException("Bundle: " + FWK_ADMIN_EQ + " is required for this test");
        }
        b.start();
        if (this.fwAdminTracker == null) {
            try {
                Filter filter = Activator.getContext().createFilter(filterFwAdmin);
                this.fwAdminTracker = new ServiceTracker(Activator.getContext(), filter, null);
                this.fwAdminTracker.open();
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        return (FrameworkAdmin)this.fwAdminTracker.getService();
    }

    protected File getTestFolder(String name) {
        return this.getTestFolder(name, true);
    }

    protected File getTestFolder(String name, boolean clean) {
        Location instanceLocation = Platform.getInstanceLocation();
        URL url = instanceLocation != null ? instanceLocation.getURL() : null;
        this.testFolder = instanceLocation == null || !instanceLocation.isSet() || url == null ? Activator.getContext().getDataFile(name) : new File(url.getFile(), name);
        if (clean && this.testFolder.exists()) {
            AbstractFwkAdminTest.delete(this.testFolder);
        }
        this.testFolder.mkdirs();
        return this.testFolder;
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.testFolder != null && this.testFolder.exists()) {
            AbstractFwkAdminTest.delete(this.testFolder);
            this.testFolder = null;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.fwAdminTracker != null) {
            this.fwAdminTracker.close();
        }
    }

    public void assertIsFile(File file) {
        if (!file.exists()) {
            AbstractFwkAdminTest.fail((String)("File: " + file.toString() + " can't be found."));
        }
        if (!file.isFile()) {
            AbstractFwkAdminTest.fail((String)("File: " + file.toString() + " is expected to be a file."));
        }
    }

    public void assertIsDirectory(File file) {
        if (!file.exists()) {
            AbstractFwkAdminTest.fail((String)("Directory: " + file.toString() + " can't be found."));
        }
        if (!file.isDirectory()) {
            AbstractFwkAdminTest.fail((String)("Directory: " + file.toString() + " is expected to be a directory."));
        }
    }

    public void assertNothing(File file) {
        if (file.exists()) {
            AbstractFwkAdminTest.fail((String)("No file or directory should be there: " + file));
        }
    }

    public void assertNotContent(File file, String search) {
        this.assertNotContent(null, file, search);
    }

    public void assertNotContent(String message, File file, String search) {
        if (!file.exists()) {
            AbstractFwkAdminTest.fail((String)("File: " + file.toString() + " can't be found."));
        }
        try {
            BufferedReader reader = null;
            try {
                String failure = null;
                StringBuilder fileContent = new StringBuilder();
                reader = new BufferedReader(new FileReader(file));
                while (reader.ready()) {
                    String line = reader.readLine();
                    fileContent.append(line).append('\n');
                    if (line.indexOf(search) < 0 || failure != null) continue;
                    failure = "The string: " + search + " was not expected in file '" + file.getAbsolutePath() + "'";
                }
                if (failure != null) {
                    AbstractFwkAdminTest.fail((String)(String.valueOf(message != null ? message : failure) + "\n" + fileContent));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            AbstractFwkAdminTest.fail((String)("String: " + search + " not found in " + file.getAbsolutePath()));
        }
    }

    public void assertIniFileNotContain(File file, String argument, String value) {
        List args = null;
        try {
            args = FileUtils.loadFile((File)file);
        }
        catch (IOException iOException) {
            AbstractFwkAdminTest.fail((String)("Can't read file " + file));
        }
        String tmp = ParserUtils.getValueForArgument((String)argument, (List)args);
        if (tmp == null) {
            return;
        }
        AbstractFwkAdminTest.assertTrue((tmp.indexOf(value) == -1 ? 1 : 0) != 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getProperty(File file, String property) {
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            p.load(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            AbstractFwkAdminTest.fail((String)("Can't find file " + file));
            if (fis == null) return p.getProperty(property);
            try {
                fis.close();
                return p.getProperty(property);
            }
            catch (IOException iOException) {}
            return p.getProperty(property);
        }
        catch (IOException iOException) {
            try {
                AbstractFwkAdminTest.fail((String)("Error reading " + file));
                if (fis == null) return p.getProperty(property);
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                fis.close();
                return p.getProperty(property);
            }
            catch (IOException iOException3) {}
            return p.getProperty(property);
        }
        if (fis == null) return p.getProperty(property);
        try {
            fis.close();
            return p.getProperty(property);
        }
        catch (IOException iOException) {}
        return p.getProperty(property);
    }

    public void assertPropertyContains(File file, String property, String text) {
        int index;
        String value = this.getProperty(file, property);
        if (value == null) {
            AbstractFwkAdminTest.fail((String)("property: " + property + " not found in: " + file));
        }
        if ((index = value.indexOf(text)) == -1) {
            AbstractFwkAdminTest.fail((String)(String.valueOf(text) + " not found in property:" + property + " for file: " + file));
        }
    }

    public void assertNotPropertyContains(File file, String property, String text) {
        String value = this.getProperty(file, property);
        if (value == null) {
            return;
        }
        int index = value.indexOf(text);
        if (index != -1) {
            AbstractFwkAdminTest.fail((String)(String.valueOf(text) + " found in property:" + property + " for file: " + file));
        }
    }

    public void assertEquals(String[] array1, String[] array2) {
        if (array1 == null || array2 == null) {
            if (array1 == array2) {
                return;
            }
            AbstractFwkAdminTest.fail((String)(array1 + " not equal to " + array2));
        }
        AbstractFwkAdminTest.assertEquals((int)array1.length, (int)array2.length);
        int i = 0;
        while (i < array1.length) {
            AbstractFwkAdminTest.assertEquals((String)array1[i], (String)array2[i]);
            ++i;
        }
    }

    public void assertContent(File file, String ... search) {
        this.assertContent(null, file, search);
    }

    public void assertContent(String message, File file, String ... lines) {
        if (!file.exists()) {
            AbstractFwkAdminTest.fail((String)("File: " + file.toString() + " can't be found."));
        }
        int idx = 0;
        StringBuilder fileContent = new StringBuilder();
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                while (reader.ready()) {
                    String line = reader.readLine();
                    fileContent.append(line).append('\n');
                    if (line.indexOf(lines[idx]) < 0 || ++idx < lines.length) continue;
                    return;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            AbstractFwkAdminTest.fail((String)("String: " + lines[idx] + " not found in " + file.getAbsolutePath()));
        }
        AbstractFwkAdminTest.fail((String)("String: " + lines[idx] + " not found in\n" + fileContent));
    }

    public void startSimpleConfiguratorManipulator() {
        Bundle manipulatorBundle = Platform.getBundle((String)"org.eclipse.equinox.simpleconfigurator.manipulator");
        if (manipulatorBundle == null) {
            AbstractFwkAdminTest.fail((String)"Bundle: org.eclipse.equinox.simpleconfigurator.manipulator is required for this test");
        }
        try {
            manipulatorBundle.start();
        }
        catch (BundleException e) {
            AbstractFwkAdminTest.fail((String)("Exception while starting up org.eclipse.equinox.simpleconfigurator.manipulator " + e.getMessage()));
        }
    }

    public void stopSimpleConfiguratorManipulator() {
        Bundle manipulatorBundle = Platform.getBundle((String)"org.eclipse.equinox.simpleconfigurator.manipulator");
        if (manipulatorBundle == null) {
            return;
        }
        try {
            manipulatorBundle.stop();
        }
        catch (BundleException e) {
            AbstractFwkAdminTest.fail((String)("Exception while starting up org.eclipse.equinox.simpleconfigurator.manipulator " + e.getMessage()));
        }
    }

    public static void copy(String message, File source, File target) {
        block26: {
            if (!source.exists()) {
                return;
            }
            target.getParentFile().mkdirs();
            if (source.isDirectory()) {
                if (target.exists() && target.isFile()) {
                    target.delete();
                }
                if (!target.exists()) {
                    target.mkdirs();
                }
                File[] children = source.listFiles();
                int i = 0;
                while (i < children.length) {
                    AbstractFwkAdminTest.copy(message, children[i], new File(target, children[i].getName()));
                    ++i;
                }
                return;
            }
            InputStream input = null;
            OutputStream output = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(source));
                    output = new BufferedOutputStream(new FileOutputStream(target));
                    byte[] buffer = new byte[8192];
                    int bytesRead = 0;
                    while ((bytesRead = input.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    AbstractFwkAdminTest.fail((String)(String.valueOf(message) + ": " + e));
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            System.err.println("Exception while trying to close input stream on: " + source.getAbsolutePath());
                            e2.printStackTrace();
                        }
                    }
                    if (output == null) break block26;
                    try {
                        output.close();
                    }
                    catch (IOException e3) {
                        System.err.println("Exception while trying to close output stream on: " + target.getAbsolutePath());
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        System.err.println("Exception while trying to close input stream on: " + source.getAbsolutePath());
                        e.printStackTrace();
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        System.err.println("Exception while trying to close output stream on: " + target.getAbsolutePath());
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected File getTestData(String message, String entry) {
        URL base;
        if (entry == null) {
            AbstractFwkAdminTest.fail((String)(String.valueOf(message) + " entry is null."));
        }
        if ((base = Activator.getContext().getBundle().getEntry(entry)) == null) {
            AbstractFwkAdminTest.fail((String)(String.valueOf(message) + " entry not found in bundle: " + entry));
        }
        try {
            String osPath = new Path(FileLocator.toFileURL((URL)base).getPath()).toOSString();
            File result = new File(osPath);
            if (!result.getCanonicalPath().equals(result.getPath())) {
                AbstractFwkAdminTest.fail((String)(String.valueOf(message) + " result path: " + result.getPath() + " does not match canonical path: " + result.getCanonicalFile().getPath()));
            }
            return result;
        }
        catch (IOException e) {
            AbstractFwkAdminTest.fail((String)(String.valueOf(message) + ": " + e));
            return null;
        }
    }

    protected Manipulator getFrameworkManipulator(File configuration, File launcher) throws BundleException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configuration);
        launcherData.setLauncher(launcher);
        return manipulator;
    }

    protected void writeEclipseIni(File location, String[] lines) {
        block15: {
            location.getParentFile().mkdirs();
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new FileWriter(location));
                    int j = 0;
                    while (j < lines.length) {
                        bw.write(lines[j]);
                        bw.newLine();
                        ++j;
                    }
                    bw.flush();
                }
                catch (IOException iOException) {
                    AbstractFwkAdminTest.fail((String)"Fail writing eclipse.ini file");
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException iOException2) {
                            AbstractFwkAdminTest.fail((String)("Fail writing eclipse.ini file in " + location));
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {
                        AbstractFwkAdminTest.fail((String)("Fail writing eclipse.ini file in " + location));
                    }
                }
                throw throwable;
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {
                    AbstractFwkAdminTest.fail((String)("Fail writing eclipse.ini file in " + location));
                }
            }
        }
    }

    protected void writeConfigIni(File location, Properties properties) {
        location.getParentFile().mkdirs();
        OutputStream out = null;
        try {
            try {
                out = new FileOutputStream(location);
                properties.store(out, "#header");
            }
            catch (IOException iOException) {
                AbstractFwkAdminTest.fail((String)("Faile writing config.ini in" + location));
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out = null;
            }
        }
        finally {
            try {
                out.flush();
                ((FileOutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            out = null;
        }
    }

    public void assertContains(String message, BundleInfo[] bundles, URI location) {
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getLocation().equals(location)) {
                return;
            }
            ++i;
        }
        AbstractFwkAdminTest.fail((String)(String.valueOf(message) + " Can't find the bundle info " + location));
    }
}

