/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import junit.framework.TestCase;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;

public class LauncherDataTest
extends TestCase {
    public LauncherDataTest(String name) {
        super(name);
    }

    public void testRemoveProgramArg() {
        LauncherData data = new LauncherData("equinox", "1.0", "eclipse", "1.0");
        data.setProgramArgs(new String[]{"-console", "-startup", "foo"});
        data.removeProgramArg("-startup");
        LauncherDataTest.assertEquals("1.0", new String[]{"-console"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "-bar"});
        data.removeProgramArg("-startup");
        LauncherDataTest.assertEquals("2.0", new String[]{"-console", "-bar"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-startup", "foo"});
        data.removeProgramArg("-startup");
        LauncherDataTest.assertEquals("3.0", new String[0], data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar"});
        data.removeProgramArg("-startup");
        LauncherDataTest.assertEquals("4.0", new String[]{"-console"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("-startup");
        LauncherDataTest.assertEquals("5.0", new String[]{"-console", "-xxx"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("foo");
        LauncherDataTest.assertEquals("6.0", new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("zzz");
        LauncherDataTest.assertEquals("7.0", new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("foo");
        LauncherDataTest.assertEquals("8.0", new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg(" ");
        LauncherDataTest.assertEquals("9.0", new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, data.getProgramArgs());
    }

    public static void assertEquals(String message, String[] one, String[] two) {
        if (one == null) {
            LauncherDataTest.assertNull((String)message, (Object)two);
        }
        if (two == null) {
            LauncherDataTest.fail((String)message);
        }
        LauncherDataTest.assertEquals((String)message, (int)one.length, (int)two.length);
        int i = 0;
        while (i < one.length) {
            LauncherDataTest.assertEquals((String)message, (String)one[i], (String)two[i]);
            ++i;
        }
    }
}

