/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class TestRunningInstance
extends AbstractFwkAdminTest {
    public TestRunningInstance(String name) {
        super(name);
    }

    public void testRunningInstance() throws BundleException {
        if ("win32".equals(Platform.getOS())) {
            return;
        }
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator m = fwkAdmin.getRunningManipulator();
        BundleInfo[] infos = m.getConfigData().getBundles();
        Bundle[] bundles = Activator.getContext().getBundles();
        TestRunningInstance.assertEquals((int)bundles.length, (int)infos.length);
        int i = 0;
        while (i < bundles.length) {
            boolean found = false;
            int j = 0;
            while (j < infos.length && !found) {
                found = this.same(infos[j], bundles[i]);
                ++j;
            }
            if (!found) {
                TestRunningInstance.fail((String)("Can't find: " + bundles[i]));
            }
            ++i;
        }
    }

    private boolean same(BundleInfo info, Bundle bundle) {
        return info.getSymbolicName().equals(bundle.getSymbolicName()) && new Version((String)bundle.getHeaders().get("Bundle-Version")).equals((Object)new Version(info.getVersion()));
    }
}

