/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.bundle;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleAdvisor {
    private final BundleContext bundleContext;

    public BundleAdvisor(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext must not be null");
        }
        this.bundleContext = bundleContext;
    }

    private Bundle getBundle(String symbolicName) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("symbolicName must not be null");
        }
        BundleContext context = this.getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            String bsn = bundle.getSymbolicName();
            boolean match = symbolicName.equals(bsn);
            if (match) {
                return bundle;
            }
            ++i;
        }
        throw new IllegalArgumentException("Failed to find bundle: " + symbolicName);
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void startBundle(String symbolicName) throws BundleException {
        Bundle bundle = this.getBundle(symbolicName);
        int state = bundle.getState();
        if (state == 32) {
            return;
        }
        bundle.start(1);
    }

    public void stopBundle(String symbolicName) throws BundleException {
        Bundle bundle = this.getBundle(symbolicName);
        bundle.stop();
    }
}

