/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.tests.util.TestWBServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class TestServletPrototype
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    final BundleContext context;
    final AtomicReference<String> lastGetName = new AtomicReference();
    final AtomicReference<String> lastUngetName = new AtomicReference();
    final ConcurrentMap<String, Factory> factories = new ConcurrentHashMap<String, Factory>();

    public TestServletPrototype(BundleContext context) {
        this.context = context;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter writer = response.getWriter();
        this.handleDoGet(request, response, writer);
    }

    protected void handleDoGet(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) throws ServletException, IOException {
        String errorCode;
        String pathInfo = request.getPathInfo();
        if ("/lastGet".equals(pathInfo)) {
            writer.print((String)this.lastGetName.getAndSet(null));
        } else if ("/lastUnget".equals(pathInfo)) {
            writer.print((String)this.lastUngetName.getAndSet(null));
        } else if ("/configure".equals(pathInfo)) {
            String prototypeName = request.getParameter("test.prototype.name");
            this.factories.putIfAbsent(prototypeName, new Factory());
            Factory factory = (Factory)this.factories.get(prototypeName);
            TestServletPrototype.configure(factory, request);
            writer.print(prototypeName);
        } else if ("/unregister".equals(pathInfo)) {
            String prototypeName = request.getParameter("test.prototype.name");
            Factory factory = (Factory)this.factories.remove(prototypeName);
            factory.unregister();
            writer.print(prototypeName);
        } else if ("/error".equals(pathInfo) && (errorCode = request.getParameter("test.error.code")) != null) {
            response.sendError(Integer.parseInt(errorCode));
        }
    }

    private static void configure(Factory factory, HttpServletRequest request) {
        String pattern;
        String contextSelect;
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        String serviceRanking = request.getParameter("service.ranking");
        if (serviceRanking != null) {
            serviceProps.put("service.ranking", new Integer(serviceRanking));
        }
        if ((contextSelect = request.getParameter("osgi.http.whiteboard.context.select")) != null) {
            serviceProps.put("osgi.http.whiteboard.context.select", contextSelect);
        }
        if ((pattern = request.getParameter("osgi.http.whiteboard.servlet.pattern")) != null) {
            serviceProps.put("osgi.http.whiteboard.servlet.pattern", pattern);
        }
        Enumeration eParamNames = request.getParameterNames();
        while (eParamNames.hasMoreElements()) {
            String name = (String)eParamNames.nextElement();
            if (!name.startsWith("servlet.init.")) continue;
            serviceProps.put(name, request.getParameter(name));
        }
        factory.setRegistrationProperties(serviceProps);
    }

    class Factory
    implements PrototypeServiceFactory<Servlet> {
        final AtomicReference<ServiceRegistration<Servlet>> registration = new AtomicReference();

        Factory() {
        }

        public Servlet getService(Bundle bundle, ServiceRegistration<Servlet> registration) {
            String name = (String)registration.getReference().getProperty("osgi.http.whiteboard.servlet.name");
            TestServletPrototype.this.lastGetName.set(name);
            return new TestWBServlet();
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Servlet> registration, Servlet service) {
            String name = (String)registration.getReference().getProperty("osgi.http.whiteboard.servlet.name");
            TestServletPrototype.this.lastUngetName.set(name);
        }

        void setRegistrationProperties(Dictionary<String, Object> serviceProps) {
            ServiceRegistration<Servlet> serviceRegistration = this.registration.get();
            if (serviceRegistration == null) {
                this.registration.set((ServiceRegistration<Servlet>)TestServletPrototype.this.context.registerService(Servlet.class, (ServiceFactory)this, serviceProps));
            } else {
                String[] stringArray = serviceRegistration.getReference().getPropertyKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (serviceProps.get(key) == null) {
                        serviceProps.put(key, serviceRegistration.getReference().getProperty(key));
                    }
                    ++n2;
                }
                serviceRegistration.setProperties(serviceProps);
            }
        }

        public void unregister() {
            ((ServiceRegistration)this.registration.getAndSet(null)).unregister();
        }
    }
}

