/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.actions;

import java.util.List;
import org.eclipse.equinox.internal.p2.ui.actions.UninstallAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.ui.actions.ProfileModificationActionTest;

public class UninstallActionTest
extends ProfileModificationActionTest {
    public void testLockedElements() {
        TestUninstallAction action = new TestUninstallAction(this.getTopLevelIUElementsWithLockedIU());
        UninstallActionTest.assertFalse((String)"Should not be enabled with locked elements", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testLockedIUs() {
        TestUninstallAction action = new TestUninstallAction(this.getTopLevelIUsWithLockedIU());
        UninstallActionTest.assertFalse((String)"Should not be enabled with locked ius", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testEmptySelection() {
        TestUninstallAction action = new TestUninstallAction(this.getEmptySelection());
        UninstallActionTest.assertFalse((String)"Should not be enabled with empty selection", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)0, (int)action.getSelectedIUs().size());
    }

    public void testTopLevelIUs() {
        TestUninstallAction action = new TestUninstallAction(this.getTopLevelIUs());
        UninstallActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testTopLevelElements() {
        TestUninstallAction action = new TestUninstallAction(this.getTopLevelIUElements());
        UninstallActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testNestedIUs() {
        TestUninstallAction action = new TestUninstallAction(this.getMixedIUs());
        UninstallActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testNestedElements() {
        TestUninstallAction action = new TestUninstallAction(this.getMixedIUElements());
        UninstallActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testMixedIUsAndNonIUs() {
        TestUninstallAction action = new TestUninstallAction(this.getMixedIUsAndNonIUs());
        UninstallActionTest.assertFalse((String)"Should not enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    public void testMixedIUsAndElements() {
        TestUninstallAction action = new TestUninstallAction(this.getMixedIUsAndElements());
        UninstallActionTest.assertTrue((String)"Should be enabled", (boolean)action.isEnabled());
        UninstallActionTest.assertEquals((int)2, (int)action.getSelectedIUs().size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestUninstallAction
    extends UninstallAction {
        TestUninstallAction(Object[] sel) {
            super(UninstallActionTest.this.getProvisioningUI(), UninstallActionTest.this.getSelectionProvider(sel), UninstallActionTest.this.profile.getProfileId());
        }

        public List<IInstallableUnit> getSelectedIUs() {
            return super.getSelectedIUs();
        }
    }
}

